DelphiVersions
==============

*(For an unofficial list of many of the most recent Delphi versions, see the "About Screens" section below.)*

This is a small suite of simple Delphi cross-platform applications that can be compiled in different versions and platforms and which displays text based on compiler directives defined by the compiler.

Read this [blog entry](https://corneliusconcepts.tech/programming-delphi-various-platforms-and-versions) for more information.

For example, if compiled as a standard Win32 application using VCL, it'll show this:

![](https://corneliusconcepts.tech/sites/default/files/10SeattleVCL_Win64_DebugSM.png)

There's also a Windows Console app in the group and that one compiled as a 64-bit app will run in the command window and look like this:

![](https://corneliusconcepts.tech/sites/default/files/XE_ConoleSM.png)

A desktop FireMonkey app was created and looks like this on a Mac:

![](https://corneliusconcepts.tech/sites/default/files/Delphi12-FireMonkey-MacOS64-DEBUG.png)

Finally, both iOS and Android phone versions were added; an old version of the Android one looks like this:

![](https://corneliusconcepts.tech/sites/default/files/AndroidPhone2.jpg)

# About Screens

The name of this repository might have some thinking this is a list of Delphi versions. That didn't occur to me until long after I had made this public and had several revisions. Recently, a [question on Delphi PRAXiS](https://en.delphipraxis.net/topic/11883-where-can-i-find-the-official-version-numbers-of-the-embarcadero-products/) prompted me to look for an official list of RAD Studio product version numbers and I was surprised not to find one. There are build numbers of the "latest" versions of products and there very well may be some list one could concoct by culling through the pages of the [DocWiki](https://docwiki.embarcadero.com/) but the closest one can find of a complete list of product numbers, at least for Delphi, is on [Wikipedia](https://en.wikipedia.org/wiki/History_of_Delphi_(software)); it's not official and it doesn't list the build numbers, so, I thought I'd augment this repository with a list of the About screens of the versions I have installed. I welcome screenshots from versions for which I don't have. You can view this [page](https://github.com/corneliusdavid/DelphiVersions/tree/master/AboutScreens) for list or just click on the links below for the ones you're interested in:

- [Delphi 12](AboutScreens/D12.1.png)
- [Delphi 11](AboutScreens/D11.3.png)
- [Delphi 10.4](AboutScreens/D10.4.png)
- Delphi 10.3 
- Delphi 10.2
- [Delphi 10.1](AboutScreens/D10.1.png)
- Delphi 10
- [Delphi XE8](AboutScreens/DXE8.png)
- [Delphi XE7](AboutScreens/DXE7.png)
- [Delphi XE6](AboutScreens/DXE6.png)
- [Delphi XE5](AboutScreens/DXE5.png)
- [Delphi XE4](AboutScreens/DXE4.png)
- [Delphi XE3](AboutScreens/DXE3.png)
- [Delphi XE2](AboutScreens/DXE2.png)
- [Delphi XE](AboutScreens/DXE.png)
- Delphi 2010
- Delphi 2009
- [Delphi 2007](AboutScreens/D2007.png)
- Delphi 2006
- [Delphi 7](AboutScreens/D7.png)
- Delphi 6
- [Delphi 5](AboutScreens/D5.png)

## References

- [Conditional Compilation](https://docwiki.embarcadero.com/RADStudio/Athens/en/Conditional_compilation_(Delphi))
- [Delphi Compiler Versions](https://docwiki.embarcadero.com/RADStudio/Athens/en/Compiler_Versions)
