+++
date = "2017-03-02T18:00:00Z"
description = "CoreDNS is now a Cloud Native Computing Foundation project."
tags = ["Kubernetes", "Service", "Discovery", "Kube-DNS"]
title = "Why CNCF for CoreDNS?"
author = "john"
+++

CoreDNS has been accepted into the [Cloud Native Computing Foundation](https://cncf.io) as an
inception project! We figure some of you may be wondering why we proposed CoreDNS as a CNCF
project, so we wrote this blog entry.

Our goal is to make CoreDNS *the* cloud-native DNS server and service discovery solution. The
CNCF as an organization is focused on the advancement of cloud-native architectures. So, to us,
this is an excellent match. Service discovery is a key component of the [CNCF cloud-native landscape](https://raw.githubusercontent.com/cncf/landscape/master/landscape/CloudNativeLandscape_v0.9.3.jpg), and this is
a role in which CoreDNS excels.

We hope this added visibility will attract more users and contributors to grow the project. And we
will be active in promoting CoreDNS, like in the up coming
[CloudNative/KubeCon](https://events.linuxfoundation.org/events/cloudnativecon-and-kubecon-europe).

CNCF provides a lot of support - evidence of which you can already see in our new logo, which was
designed by the team at the Linux Foundation (of which CNCF is a part). As a CNCF project, we will
have space at CloudNativeCon/KubeCon and other events to interact with users and get feedback on
how the community is using CoreDNS. Additionally, we gain access to deep experience and wide ranging use
cases of the CNCF end user community. This helps inform the future development of CoreDNS, ensuring
that we move in directions that solve meaningful problems in cloud-native architectures.

We are also planning to take advantage of the [CNCF cluster](https://www.cncf.io/cluster), which will
allow us to really push the scale limits of CoreDNS when operating against large Kubernetes clusters
or other high-scale environments. We need that kind of battle-testing to ensure CoreDNS becomes the
best option for cloud-native DNS and service discovery.
