from conan import ConanFile
from conan.tools.build import check_min_cppstd
from conan.tools.files import copy, get
from conan.tools.layout import basic_layout
import os

required_conan_version = ">=1.50.0"


class TlOptionalConan(ConanFile):
    name = "tl-optional"
    url = "https://github.com/conan-io/conan-center-index"
    homepage = "https://tl.tartanllama.xyz"
    description = "C++11/14/17 std::optional with functional-style extensions and reference support"
    topics = ("cpp11", "cpp14", "cpp17", "optional")
    license = "CC0-1.0"
    settings = "os", "arch", "compiler", "build_type"
    no_copy_source = True

    def package_id(self):
        self.info.clear()

    def validate(self):
        if self.settings.compiler.get_safe("cppstd"):
            check_min_cppstd(self, 11)

    def layout(self):
        basic_layout(self, src_folder="src")

    def source(self):
        get(self, **self.conan_data["sources"][self.version],
            destination=self.source_folder, strip_root=True)

    def build(self):
        pass

    def package(self):
        copy(self, "*", src=os.path.join(self.source_folder, "include"), dst=os.path.join(self.package_folder, "include"))
        copy(self, "COPYING", src=self.source_folder, dst=os.path.join(self.package_folder, "licenses"))

    def package_info(self):
        self.cpp_info.set_property("cmake_file_name", "tl-optional")
        self.cpp_info.set_property("cmake_target_name", "tl::optional")
        self.cpp_info.bindirs = []
        self.cpp_info.frameworkdirs = []
        self.cpp_info.libdirs = []
        self.cpp_info.resdirs = []

        # TODO: to remove in conan v2 once cmake_find_package* generators removed
        self.cpp_info.filenames["cmake_find_package"] = "tl-optional"
        self.cpp_info.filenames["cmake_find_package_multi"] = "tl-optional"
        self.cpp_info.names["cmake_find_package"] = "tl"
        self.cpp_info.names["cmake_find_package_multi"] = "tl"
        self.cpp_info.components["optional"].names["cmake_find_package"] = "optional"
        self.cpp_info.components["optional"].names["cmake_find_package_multi"] = "optional"
        self.cpp_info.components["optional"].set_property("cmake_target_name", "tl::optional")
        self.cpp_info.components["optional"].bindirs = []
        self.cpp_info.components["optional"].frameworkdirs = []
        self.cpp_info.components["optional"].libdirs = []
        self.cpp_info.components["optional"].resdirs = []
