import os

from conan import ConanFile
from conan.tools.cmake import CMake, CMakeToolchain, cmake_layout
from conan.tools.files import copy, get, rmdir

required_conan_version = ">=1.50.0"


class TermcolorConan(ConanFile):
    name = "termcolor"
    description = "Termcolor is a header-only C++ library for printing colored messages to the terminal."
    topics = ("terminal", "color")
    license = "BSD-3-Clause"
    homepage = "https://github.com/ikalnytskyi/termcolor"
    url = "https://github.com/conan-io/conan-center-index"
    package_type = "header-library"
    settings = "os", "arch", "compiler", "build_type"
    no_copy_source = True

    def layout(self):
        cmake_layout(self, src_folder="src")

    def package_id(self):
        self.info.clear()

    def source(self):
        get(self, **self.conan_data["sources"][self.version], strip_root=True)

    def generate(self):
        tc = CMakeToolchain(self)
        tc.generate()

    def build(self):
        cmake = CMake(self)
        cmake.configure()
        cmake.build()

    def package(self):
        copy(self, "LICENSE", src=self.source_folder, dst=os.path.join(self.package_folder, "licenses"))
        cmake = CMake(self)
        cmake.install()
        rmdir(self, os.path.join(self.package_folder, "lib", "cmake"))

    def package_info(self):
        self.cpp_info.set_property("cmake_file_name", "termcolor")
        self.cpp_info.set_property("cmake_target_name", "termcolor::termcolor")
        self.cpp_info.bindirs = []
        self.cpp_info.libdirs = []
