from conan import ConanFile
from conan.tools.files import copy, get
from conan.tools.layout import basic_layout
import os

required_conan_version = ">=1.50.0"


class HalfConan(ConanFile):
    name = "half"
    description = (
        "C++ header-only library to provide an IEEE 754 conformant 16-bit "
        "half-precision floating-point type along with corresponding "
        "arithmetic operators, type conversions and common mathematical "
        "functions."
    )
    license = "MIT"
    topics = ("half-precision", "float", "arithmetic")
    homepage = "https://sourceforge.net/projects/half"
    url = "https://github.com/conan-io/conan-center-index"
    package_type = "header-library"
    settings = "os", "arch", "compiler", "build_type"
    no_copy_source = True

    def layout(self):
        basic_layout(self, src_folder="src")

    def package_id(self):
        self.info.clear()

    def source(self):
        get(self, **self.conan_data["sources"][self.version])

    def build(self):
        pass

    def package(self):
        copy(self, "LICENSE.txt", src=self.source_folder, dst=os.path.join(self.package_folder, "licenses"))
        copy(self, "half.hpp", src=os.path.join(self.source_folder, "include"), dst=os.path.join(self.package_folder, "include"))

    def package_info(self):
        self.cpp_info.bindirs = []
        self.cpp_info.libdirs = []
