from conan import ConanFile
from conan.tools.cmake import CMake, CMakeDeps, CMakeToolchain, cmake_layout
from conan.tools.files import copy, get, rmdir
import os


required_conan_version = ">=1.56.0"


class dnetConan(ConanFile):
    name = "dnet"
    description = "Provides a simplified, portable interface to several low-level networking routines."
    homepage = "https://github.com/ofalk/libdnet"
    topics = ("dnet", "libdnet", "libdumbnet")
    license = "BSD-3-Clause"
    url = "https://github.com/conan-io/conan-center-index"
    package_type = "library"
    options = {
        "shared": [True, False],
        "fPIC": [True, False],
    }
    default_options = {
        "shared": False,
        "fPIC": True
    }
    settings = "os", "arch", "compiler", "build_type"


    def layout(self):
        cmake_layout(self, src_folder="src")

    def config_options(self):
        if self.settings.os == "Windows":
            del self.options.fPIC

    def configure(self):
        if self.options.shared:
            self.options.rm_safe("fPIC")
        # This is a pure C project
        self.settings.rm_safe("compiler.cppstd")
        self.settings.rm_safe("compiler.libcxx")

    def source(self):
        get(self, **self.conan_data["sources"][self.version], strip_root=True)

    def generate(self):
        tc = CMakeToolchain(self)
        tc.generate()

        deps = CMakeDeps(self)
        deps.generate()

    def build(self):
        cmake = CMake(self)
        cmake.configure()
        cmake.build()
    
    def package(self):
        copy(self,"LICENSE", src=self.source_folder, dst=os.path.join(self.package_folder, "licenses"))
        cmake = CMake(self)
        cmake.configure()
        cmake.install()
        rmdir(self, os.path.join(self.package_folder, "lib", "cmake"))

    def package_info(self):
        self.cpp_info.libs.append("dnet")
        self.cpp_info.includedirs.append(os.path.join("include", "dnet"))
 
        if self.settings.os == 'Windows':
            self.cpp_info.system_libs = ['Iphlpapi', 'wsock32']
