from conan import ConanFile
from conan.tools.build import check_min_cppstd
from conan.tools.files import copy, get
from conan.tools.layout import basic_layout
import os

required_conan_version = ">=1.50.0"


class CppcodecConan(ConanFile):
    name = "cppcodec"
    license = "MIT"
    url = "https://github.com/conan-io/conan-center-index"
    homepage = "https://github.com/tplgy/cppcodec"
    description = (
        "Header-only C++11 library to encode/decode base64, base64url, base32, "
        "base32hex and hex (a.k.a. base16) as specified in RFC 4648, plus Crockford's base32"
    )
    topics = ("base64", "cpp11", "codec", "base32")
    package_type = "header-library"
    settings = "os", "arch", "compiler", "build_type"
    no_copy_source = True

    def layout(self):
        basic_layout(self, src_folder="src")

    def package_id(self):
        self.info.clear()

    def validate(self):
        if self.settings.compiler.get_safe("cppstd"):
            check_min_cppstd(self, 11)

    def source(self):
        get(self, **self.conan_data["sources"][self.version], strip_root=True)

    def build(self):
        pass

    def package(self):
        copy(self, "*hpp", src=os.path.join(self.source_folder, "cppcodec"), dst=os.path.join(self.package_folder, "include", "cppcodec"))
        copy(self, "LICENSE", src=self.source_folder, dst=os.path.join(self.package_folder, "licenses"))

    def package_info(self):
        self.cpp_info.set_property("pkg_config_name", "cppcodec-1")
        self.cpp_info.bindirs = []
        self.cpp_info.libdirs = []
