/*
 * This file is part of communikey.
 * Copyright (C) 2016-2018  communicode AG <communicode.de>
 *
 * communikey is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * The instance name of the global {@link AuthStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.8.0
 */
export const AUTH_STORE = "authStore";

/**
 * The instance name of the global {@link AuthorityStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.11.0
 */
export const AUTHORITY_STORE = "authorityStore";

/**
 * The instance name of the global {@link CategoryStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.8.0
 */
export const CATEGORY_STORE = "categoryStore";

/**
 * The instance name of the global {@link KeyStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.8.0
 */
export const KEY_STORE = "keyStore";

/**
 * The instance name of the global {@link UserStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.8.0
 */
export const USER_STORE = "userStore";

/**
 * The instance name of the global {@link UserGroupStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.9.0
 */
export const USER_GROUP_STORE = "userGroupStore";

/**
 * The instance name of the global {@link EncryptionJobStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.15.0
 */
export const ENCRYPTION_JOB_STORE = "encryptionJobStore";

/**
 * The instance name of the global {@link EventStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.15.0
 */
export const EVENT_STORE = "eventStore";

/**
 * The instance name of the global {@link TagStore} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.18.0
 */
export const TAG_STORE = "tagStore";

/**
 * The instance name of the global {@link InvocationHelper} injected through the MobX React {@linkcode Provider}.
 *
 * @type {string}
 * @since 0.15.0
 */
export const INVOCATION_HELPER = "invocationHelper";