/*
 * This file is part of communikey.
 * Copyright (C) 2016-2018  communicode AG <communicode.de>
 *
 * communikey is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * The path variable for a authority name.
 *
 * @constant
 * @default
 * @type {string}
 * @since 0.8.0
 */
export const AUTHORITY_NAME = "/${authorityName}";

/**
 * The path variable for a category ID.
 *
 * @constant
 * @default
 * @type {string}
 * @since 0.8.0
 */
export const CATEGORY_ID = "/${categoryId}";

/**
 * The path variable for a key ID.
 *
 * @constant
 * @default
 * @type {string}
 * @since 0.8.0
 */
export const KEY_ID = "/${keyId}";

/**
 * The path variable for a user group ID.
 *
 * @constant
 * @default
 * @type {number}
 * @since 0.8.0
 */
export const USER_GROUP_ID = "/${userGroupId}";

/**
 * The path variable for a user login.
 *
 * @constant
 * @default
 * @type {string}
 * @since 0.8.0
 */
export const USER_LOGIN = "/${login}";

/**
 * The path variable for a tag.
 *
 * @constant
 * @default
 * @type {string}
 * @since 0.18.0
 */
export const TAG_ID = "/${tagId}";