# v5 to v6 Migration Guide

Version 6 includes a few notable framework upgrades, including [React 19](https://react.dev/blog/2024/12/05/react-19) and [Next.js 15](https://nextjs.org/blog/next-15). It also includes substantial changes to dev tooling, including migrating to ESLint 9 flat config and adding more strict and opinionated rules.

As a result of these substantial changes, migration may be complicated for some users. If your fork of the project only changes CMS data, it should be pretty straightforward. If you've made customizations to styles and components, it could be easier to start fresh and migrate your changes individually if you want to incorporate v6.

To begin a migration:

```bash
// add the original repo as a git remote
git remote add upstream git@github.com:colinhemphill/nextjs-resume.git

// pull changes from upstream
git pull upstream main
```

I wasn't originally planning to include a guide, but migrating my personal résumé went very smoothly, so hopefully it works just as well for you. There will definitely be a few merge conflicts though.

## Content changes

### Job titles

Each `ProfessionalExperience` document in the CMS now requires a `titles` field which is an array of `ProfessionalTitle` documents. A `ProfessionalTitle` includes `title`, `startDate`, `endDate` (optional), and `description` (optional).

This array replaces the `startDate`, `endDate`, and `title` fields that used to be on a `ProfessionalExperience`, as well as the array of `PreviousTitle` documents, and combines them into one. Now you must list each title separately, and if you only have one title within an organization just list it as the first entry in the list.

## Linter changes

### Filenames

Almost every filename has changed as a result of ESLint rules to kebab case format. If you customized a file, Git should pick up the name change, but if you added files you will likely have to change their names.

### Strictness

The new linter rules are strict and opinionated. Apologies in advance.

## Styles

Many component styles and layouts have changed, so customizations may incur merge conflicts, but basic resume config settings should continue to work.

Some Tailwind CSS bases and utilities have moved out of the `globals.css` file and into the Tailwind config file.

Thanks to the array of titles for a given organization, current and past titles are now displayed on a timeline.
