# v3 to v4 Migration Guide

Version 4 introduces [Contentlayer](https://www.contentlayer.dev/) as the SDK to to manage schemas, generate types, and read Markdown data to use as JSON within the application and PDF. It requires a few small changes if you're upgrading from Version 3.

## Content changes

### Move your content

When you upgrade there will be a new folder at `/edit-me/content`. Delete all files in this folder, then move all files from the existing `/edit-me/cms` folder into `/edit-me/content`.

### Update your content

1. In your `achievements` MD files, update the `institution` field to instead be called `organization`
2. Rename the `hobbies.md` file to `additionalInfo.md`
   1. Add `title` Frontmatter field to the `additionalInfo.md` file (this will set the title of that section, e.g. "Hobbies and Interests")

### Move your config

Your link configuration at `/edit-me/cms/links.ts` should instead be in `/edit-me/config/links.ts`. Copy your existing config into this new file, noting that the import for the `CMSLink[]` type has moved.

## Other changes

- If you have customized schemas for your content, you will now need to update these in `contentlayer.config.js` at the application root
- The `getCMSIntegration()` helper and related MD reading code has been removed. You now get Markdown data generated by Contentlayer by importing it from `@content`. Data is generated at build time and can be used on the server or the client.
- The OG image is now generated using [file-based metadata](https://beta.nextjs.org/docs/api-reference/metadata#open-graph-images) at `/src/app/opengraph-image`
- Tests have been migrated from Jest to Vitest
