<h3 align="center">
  <br />
  <img src="https://user-images.githubusercontent.com/168240/39561871-51cda852-4e5d-11e8-926b-7692d43143e8.png" alt="logo" width="400" />
  <br />
  <br />
  <br />
</h3>

# cointop

> Coin tracking for hackers

[![License](http://img.shields.io/badge/license-Apache-blue.svg)](https://raw.githubusercontent.com/cointop-sh/cointop/master/LICENSE)
[![Build Status](https://travis-ci.org/cointop-sh/cointop.svg?branch=master)](https://travis-ci.org/cointop-sh/cointop)
[![Go Report Card](https://goreportcard.com/badge/github.com/cointop-sh/cointop?)](https://goreportcard.com/report/github.com/cointop-sh/cointop)
[![GoDoc](https://godoc.org/github.com/cointop-sh/cointop?status.svg)](https://godoc.org/github.com/cointop-sh/cointop)
[![Mentioned in Awesome Terminals](https://awesome.re/mentioned-badge.svg)](https://github.com/k4m4/terminals-are-sexy)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](#contributing)

[`cointop`](https://github.com/cointop-sh/cointop) is a fast and lightweight interactive terminal based UI application for tracking and monitoring cryptocurrency coin stats in real-time.

The interface is inspired by [`htop`](https://en.wikipedia.org/wiki/Htop) and shortcut keys are inspired by [`vim`](https://en.wikipedia.org/wiki/Vim_(text_editor)).

<img src="https://user-images.githubusercontent.com/168240/39569578-7ce9f3b6-4e7a-11e8-82a9-8a18b91b1bd5.png" alt="cointop screenshot" width="880" />

## Demo

This connects to an instance of Cointop using SSH:

```bash
ssh cointop.sh
```

In action

<img src="https://user-images.githubusercontent.com/168240/39569570-75b1547c-4e7a-11e8-8eac-552abaa431f0.gif" alt="screencast" width="880" />

## Table of Contents

Documentation has been moved to [docs.cointop.sh](https://docs.cointop.sh/)

- [Features](#features)
- [Documentation](https://docs.cointop.sh/)
- [Install](https://docs.cointop.sh/install)
- [Update](https://docs.cointop.sh/update)
- [Getting started](https://docs.cointop.sh/getting-started)
- [Shortcuts](https://docs.cointop.sh/shortcuts)
- [Colorschemes](https://docs.cointop.sh/colorschemes)
- [Config](https://docs.cointop.sh/config)
- [SSH server](https://docs.cointop.sh/ssh)
- [FAQ](https://docs.cointop.sh/faq)
- [Contributing](#contributing)
- [Social](#social)
- [Mentioned in](#mentioned-in)
- [Tip Jar](#tip-jar)
- [License](#license)

## Features

- **Shortcut keys**: Vim-inspired shortcut keys, custom key bindings configuration
- **Colorschemes**: Custom colorscheme configuration, 256-color and 24-bit support
- **Favorites**: Save and view favorite coins
- **Portfolio**: Portfolio tracking of holdings, view profit & loss
- **Charts**: Charts for coin price history and global market graphs
- **Search**: Fuzzy searching for finding coins
- **Conversion**: Currency conversion
- **Price Alerts**: Price alerts with desktop notifications
- **Multiple APIs**: Supports multiple coin data APIs; CoinGecko and CoinMarketCap
- **Mouse**: Mouse support
- **Offline**: Offline cache
- **Fast**: Fast sort shortcuts, pagination, chart date range change, auto-refresh
- **Lightweight**: It's very lightweight; can be left running indefinitely

## Contributing

See [docs.cointop.sh/contributing](https://docs.cointop.sh/contributing)

_Many thanks to [Simon Roberts](https://github.com/lyricnz), [Alexis Hildebrandt](https://github.com/afh), and all the [contributors](https://github.com/cointop-sh/cointop/graphs/contributors) that made cointop better._

## Social

- Follow on twitter [@cointop](https://twitter.com/cointop)
- Discuss on [Discord](https://discord.gg/pUVGy7ECGg)

## Mentioned in

Cointop has been mentioned in:

- [@Ubuntu Twitter](https://twitter.com/ubuntu/status/985947962311311360?lang=en)
- [Terminals Are Sexy](https://github.com/k4m4/terminals-are-sexy#tools-and-plugins)
- [The Changelog News](https://changelog.com/news/cointop-coin-tracking-for-hackers-rAzZ)

### Tip Jar

[![BTC Tip Jar](https://img.shields.io/badge/BTC-tip-yellow.svg?logo=bitcoin&style=flat)](https://www.blockchain.com/btc/address/3KdMW53vUMLPEC33xhHAUx4EFtvmXQF8Kf) `3KdMW53vUMLPEC33xhHAUx4EFtvmXQF8Kf`

[![ETH Tip Jar](https://img.shields.io/badge/ETH-tip-blue.svg?logo=ethereum&style=flat)](https://etherscan.io/address/0xC014b8F6F43f467922E93De62C9216F0538E0F8f) `0xC014b8F6F43f467922E93De62C9216F0538E0F8f`

Thank you for tips! 🙏

## License

Released under the [Apache 2.0](./LICENSE) license.

© [Miguel Mota](https://github.com/miguelmota)
