import type { Config } from 'tailwindcss';

const config: Config = {
  content: [
    './app/**/*.{js,ts,jsx,tsx,mdx}',
    './src/components/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    container: {
      center: true,
      screens: {
        sm: '640px',
        md: '768px',
        lg: '1024px',
        xl: '1280px',
      },
    },
    extend: {
      backgroundImage: {
        'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
        'gradient-conic':
          'conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))',
        'gradient-2': 'linear-gradient(270deg, #f55925 0%, #D75986 100%)',
      },
      gridTemplateColumns: {
        // Coffee column grid
        '2CoffeeLg': '1fr 380px',
        '2CoffeeMd': '1fr 330px',

        // Mint colum grid
        '2mint': '420px 1fr',
      },
      colors: {
        'boat-footer-dark-gray': '#141519',
        'boat-footer-light-gray': '#8a919e',
        'boat-color-gray-900': '#191918',
        'boat-color-blue-40': '#1354e1',
        'boat-color-green-40': '#0b8552',
        'boat-color-palette-backgroundalternate': '#141519',
        'boat-color-palette-foreground': '#fff',
        'boat-color-palette-foregroundmuted': '#8a919e;',
        'boat-color-palette-line': '#8a919e33',
        'boat-color-pink-50': '#d058c1',
        'boat-color-purple-60': '#b388f5',
        'boat-color-yellow-60': '#e9b300',
        'boat-color-yellow-70': '#FFD200',
        'boat-color-orange': '#f55925',
        'boat-gold': '#7b602f',
      },
    },
  },
  plugins: [],
};

export default config;
