# Contributing to Build Onchain Apps

🎉 First off, thank you for considering contributing to Build Onchain Apps, you are the best! ☕️

The following is a set of guidelines for contributing to Base Web. These are just guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Table of Contents

- [Code of Conduct](#code-of-conduct)
- [How Can I Contribute?](#how-can-i-contribute)
  - [Reporting Bugs](#reporting-bugs)
  - [Suggesting Enhancements](#suggesting-enhancements)
  - [Pull Requests](#pull-requests)
- [Coding Conventions](#coding-conventions)

## Code of Conduct

This project and everyone participating in it are governed by our [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

## How Can I Contribute?

### Reporting Bugs

1. **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/coinbase/build-onchain-apps/issues).

2. If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/coinbase/build-onchain-apps/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

### Suggesting Enhancements

1. **Check the [Issues](https://github.com/coinbase/build-onchain-apps/issues)** to see if there's someone who has already suggested the same enhancement.

2. If it doesn't exist, [create a new issue](https://github.com/coinbase/build-onchain-apps/issues/new). Provide a clear and detailed explanation of the feature you want and why it's important to add.

### Pull Requests

1. **Fork the repository** and create your branch from `main`.

2. **Make your changes**: Apply your changes, following the coding conventions described below.

3. **Commit your changes**: Commit your changes using a descriptive commit message.

4. **Open a Pull Request**: Describe what you did in the pull request description. Mention the issue number if your pull request is related to an existing issue.

5. **Include Screenshots**: If your pull request includes any visual changes to the project, please include before and after screenshots in your pull request description to help us better understand the changes.

6. **Wait for review**: Once your pull request is opened, it will be reviewed as soon as possible. Changes may be requested, and your responsiveness is appreciated.

## Coding Conventions

- Use clear and descriptive variable names.
- Comment your code where necessary.
- Follow the lint configurations.
