# Confluence Quick Start Connector

This package is a utility for connecting Cohere to Confluence, featuring a simple local development setup.

## Limitations

The Confluence connector will search within the space defined in your `.env`, and performs a case-insensitive full-text
search against all text fields Confluence indexes by default.

Note: The search uses Confluence's advanced search language called [CQL](https://developer.atlassian.com/cloud/confluence/advanced-searching-using-cql/). If you wish to customize this connector's search experience, please refer to the above linked documentation for more details.

## Configuration

There are two authentication methods available with this connector. You can either set it up using the service auth
method, or with OAuth.

### Service Auth

When using the service auth method, you must set the following env vars:

```
CONFLUENCE_AUTH_METHOD: Set to "service_auth"
CONFLUENCE_USER: User email address
CONFLUENCE_API_TOKEN: API token
CONFLUENCE_PRODUCT_URL: URL to your Confluence instance, including https:// schema
CONFLUENCE_SPACE_NAME: Name of a space within your Confluence wiki
```

The API token can be generated by logging into Confluence and going to the [API tokens page](https://id.atlassian.com/manage-profile/security/api-tokens).

### OAuth

When using OAuth for authentication, the connector does not require any additional environment variables. Instead,
the OAuth flow should occur outside the Connector and Cohere's API will forward the user's access token to this
connector through the `Authorization` header.

To use OAuth, you must first create an OAuth 2.0 app in Confluence. To do this, go to the
Atlassian [Developer Console](https://developer.atlassian.com/console/myapps/), and use the option to create a new
OAuth 2.0 integration.

You must configure in the developer console the OAuth scopes that are allowed to be requested by the client. There are
two options in Confluence, classic scopes or granular scopes. Use the granular scopes option, and ensure that the
following are enabled:

* read:content:confluence
* read:content-details:confluence
* read:page:confluence
* read:custom-content:confluence

The `offline_access` scope must also be requested for refresh tokens to work. This scope does not appear in the
list of scopes in the Atlassian OAuth permissions page, but it must be included in the scopes added to the connector
configuration in Cohere dashboard.

You must also configure the authorization settings. Go to the Authorization page, and configure the app to use the
authorization type OAuth 2.0 (3L0). On the configuration page for the authorization page, enter the callback URL as:

https://api.cohere.com/v1/connectors/oauth/token

Go to the settings option for the app, enter the app name and description under general settings, and then take
note of the OAuth client id and secret from this page.

Once your Confluence OAuth credentials are ready, you can register the connector in Cohere's API with the following
configuration:

```bash
curl  -X POST \
  'https://api.cohere.ai/v1/connectors' \
  --header 'Accept: */*' \
  --header 'Authorization: Bearer {COHERE-API-KEY}' \
  --header 'Content-Type: application/json' \
  --data-raw '{
  "name": "Confluence",
  "url": "{YOUR_CONNECTOR-URL}",
  "oauth": {
    "client_id": "{CONFLUENCE-OAUTH-CLIENT-ID}",
    "client_secret": "{CONFLUENCE-OAUTH-CLIENT-SECRET}",
    "authorize_url": "https://auth.atlassian.com/authorize?audience=api.atlassian.com&response_type=code&prompt=consent",
    "token_url": "https://auth.atlassian.com/oauth/token",
    "scope": "read:content:confluence read:content-details:confluence read:page:confluence read:custom-content:confluence offline_access"
  }
}'
```

With OAuth the connector will be able to search any Confluence pages that the user has access to.

### Optional Configuration

```
CONFLUENCE_SEARCH_LIMIT
```

This variable can be used to limit the number of results returned by the connector.
By default, the connector will return 10 results.

```
CONFLUENCE_CONNECTOR_API_KEY
```

This variable can be used to set an API key for the connector.

```
CONFLUENCE_AUTH_METHOD
```

This variable is used to configure the connector to use service auth or OAuth authentication. The valid
values are `service_auth` and `oauth`. The default is to run the connector in OAuth mode.

```
CONFLUENCE_EXTENDED_STOPWORDS
```

The connector filters out stop words from NLTK. This variable can be used to extend the NLK stop word list with
a more comprehensive list.

These variables can optionally be put into a `.env` file for development.
A `.env-template` file is provided with all the environment variables that are used by this demo.

## Development

Create a virtual environment and install dependencies with poetry. We recommend using in-project virtual environments:

```bash
  $ poetry config virtualenvs.in-project true
  $ poetry install --no-root
```

To load some test documents into Confluence, this repo provides a `load_data.py` script in `dev/`.

```bash
  $ poetry shell
  $ python dev/load_data.py
```

Next, start up the connector's server:

```bash
  $ poetry run flask --app provider --debug run --port 5000
```

and check with curl to see that everything works:

```bash
  curl --request POST \
    --url http://localhost:5000/search \
    --header 'Content-Type: application/json' \
    --header 'Authorization: Bearer <CONNECTOR_API_KEY>' \
    --data '{
      "query": "BBQ"
    }'
```

Alternatively, load up the Swagger UI and try out the API from a browser: http://localhost:5000/ui/
