# Cohere Quick Start Connectors contributing guide

Thank you for your interest in contributing to Cohere's connector. This guide will explain the contribution workflow from opening an issue, creating a PR, to reviewing and merging the PR.

# Getting Started

Remember that there are many ways to contribute other than writing code: writing tutorials or blog posts, improving [the documentation](https://docs.cohere.com), and submitting bug reports.

## Table of Contents

- [Assumptions](#assumptions)
- [How to Contribute](#how-to-contribute)
- [Development Workflow](#development-workflow)
- [Git Guidelines](#git-guidelines)
- [Release Process (for internal team only)](#release-process-for-internal-team-only)

## Assumptions

1. **You're familiar with [GitHub](https://github.com) and the [Pull Requests (PR)](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests) workflow.**
2. **You've read the Cohere's [documentation](https://docs.cohere.com).**
3. \*\*You know about the [Cohere community on Discord](https://discord.com/invite/co-mmunity).

## How to Contribute

1. Ensure your change has an issue! Find an
   existing issue or open a new issue.
   - This is where you can get a feel if the change will be accepted or not.
2. Once approved, fork this repository repository in your own GitHub account.
3. [Create a new Git branch](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-and-deleting-branches-within-your-repository)
4. Make your changes on your branch.
5. [Submit the branch as a Pull Request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request-from-a-fork) pointing to the `main` branch this repository. A maintainer should comment and/or review your Pull Request within a few days. Although depending on the circumstances, it may take longer.
