# Free Web Developer Resources 📚

A collection of free resources to help Web Developers.

## Contributions welcome! 🙌

Please read [`contributing guidelines`](./CONTRIBUTING.md) if you'd like to add resources.

## Star this repository ⭐

Please ⭐ this repository if you found it helpful!
It makes it easier for new people to find this repository.

## Table Of Contents 📖

- [Accessibility](#accessibility)
- [APIs](#apis)
- [Blog](#blog)
- [Books](#books)
- [Community](#community)
- [Courses](#courses)
- [CSS](#css)
  - [Animation](#css-animation)
  - [Frameworks](#css-frameworks)
  - [Tools](#css-tools)
- [Database](#database)
- [Design](#design)
  - [Colors](#colors)
  - [Fonts](#fonts)
  - [Gradients](#gradients)
  - [Icons](#icons)
  - [Illustrations](#illustrations)
  - [Inspiration](#inspiration)
  - [Patterns](#patterns)
  - [Photos](#photos)
- [Developer Tools](#developer-tools)
  - [All](#developer-tools)
  - [Authentication](#authentication)
  - [Chrome Extensions](#chrome-extensions)
  - [Domain Name](#domain-name)
  - [Generators](#generators)
  - [Hosting](#hosting)
  - [Optimization](#optimization)
  - [Online Code Editors](#online-code-editors)
  - [Project Management](#project-management)
  - [Validation](#validation)
- [Newsletters](#newsletters)
- [Podcasts](#podcasts)
- [Practice](#practice)
- [YouTube](#youtube-channels)
  - [All](#youtube-channels)
  - [Backend](#backend-yt)
  - [Blockchain](#blockchain-yt)
  - [Devops](#devops-yt)
  - [Frontend](#frontend-yt)
  - [Mobile](#mobile-yt)

---

## Accessibility

| Resource | Description |
| :--- | :--- |
| [Accessibility Cheat-sheet](https://moritzgiessmann.de/accessibility-cheatsheet/) | Practical approaches to Universal Design for making your website/webapp accessible to everyone |
| [Color Contrast Accessibility Validator](https://color.a11y.com/) | Color Contrast Accessibility Validator |
| [WAI Tutorials](https://www.w3.org/WAI/design-develop/) | Guidance for writing, designing, and developing for accessiblity |

## APIs

| Resource | Description |
| :--- | :--- |
| [JSON Placeholder](https://jsonplaceholder.typicode.com/) | Free fake API for testing and prototyping. |
| [Open Trivia Database](https://opentdb.com/) | Free to use, user-contributed trivia question database. 4,102 verified questions. |
| [OpenWeather](https://openweathermap.org/guide) | Weather data in a fast and easy-to-use way |
| [Public API List](https://github.com/public-apis/public-apis) | A collective list of free APIs for use in software and web development. |
| [The Star Wars API](https://swapi.dev/) | All the Star Wars data you've ever wanted: Planets, Spaceships, Vehicles, People, Films and Species |
| [They Said So Quotes API](http://quotes.rest/) | They Said So Quotes API offers a complete feature rich REST API access to its quotes platform. |
| [OMDb API](http://www.omdbapi.com/) | The OMDb API is a RESTful web service to obtain movie information, all content and images on the site are contributed and maintained by our users. |
| [Random Data API](https://random-data-api.com/documentation) | Use any of our API endpoints and fetch data that will allow you faster development and testing cycle. All responses come with ID (integer) and UID (string). |
| [REST Countries](https://restcountries.com/) | Get information about countries via a RESTful API. |

## Blog

| Resource | Description |
| :--- | :--- |
| [Catalin Pit](https://catalins.tech/) | All about software engineering, developer health, resources and content creation |
| [Codepen blog](https://blog.codepen.io) | Announcements, tips and tricks, new and updated features, fun roundups, new podcast episodes, and more. |
| [CSS Tricks](https://css-tricks.com/) | Blog articles curated by CSS Tricks |
| [Dev.to](https://dev.to/) | DEV is a community of software developers getting together to help one another out. The software industry relies on collaboration and networked learning. We provide a place for that to happen. |
| [Flavio Copes](https://flaviocopes.com/) | Flavio Copes Blog |
| [Netflix Tech Blog](https://netflixtechblog.com) | The Netflix Tech Blog |
| [Pinterest Engineering](https://medium.com/pinterest-engineering) | Pinterest Engineering. Inventive engineers building the first visual discovery engine, 300 billion ideas and counting. |
| [DigitalOcean Community](https://www.digitalocean.com/community) | DigitalOcean’s community offers thousands of tutorials, videos, and answers to questions on a wide range of topics. |
| [Smashing Magazine](https://www.smashingmagazine.com/articles/) | Smashing Magazine - Articles, books, workshops, conferences, membership, job board, newsletter and more |
| [Spotify Engineering](https://engineering.atspotify.com) | Read about the magic behind the music and more. Welcome to our official technology blog. |
| [The Pragmatic Engineer](https://blog.pragmaticengineer.com) | Newsletter, books, jobs and talent collective |

## Books

| Resource | Description |
| :--- | :--- |
| [Automate The Boring Stuff With Python (2nd edition)](https://automatetheboringstuff.com/2e/chapter0/) | In Automate the Boring Stuff with Python, you'll learn how to use Python to write programs that do in minutes what would take you hours to do by hand - no prior programming experience required. |
| [Eloquent JavaScript (3rd Edition)](https://eloquentjavascript.net/) | This is a book about JavaScript, programming, and the wonders of the digital. |
| [Functional-Light JavaScript](https://github.com/getify/Functional-Light-JS) | "Functional-Light JavaScript" explores the core principles of functional programming (FP) as they are applied to JavaScript. But what makes this book different is that we approach these principles without drowning in all the heavy terminology. We look at a subset of FP foundational concepts that I call "Functional-Light Programming" (FLP) and apply it to JavaScript. |
| [The Pragmatic Programmer: Your journey to mastery (20th anniversary edition)](https://www.amazon.co.uk/Pragmatic-Programmer-journey-mastery-Anniversary/dp/0135957052/ref=sr_1_1?adgrpid=52230164094&hvadid=606130036203&hvdev=c&hvlocphy=1006919&hvnetw=g&hvqmt=e&hvrand=18428663416613634506&hvtargid=kwd-302199567278&hydadcr=17611_2289039&keywords=the+pragmatic+programmer&qid=1704899886&sr=8-1) | Jammed full of coding best practices, after 20 years it's still one of the must read books on building a successful career in software. |
| [You Don't Know JS](https://github.com/getify/You-Dont-Know-JS) | This is a series of books diving deep into the core mechanisms of the JavaScript language. |

## Community

| Resource | Description |
| :--- | :--- |
| [Codú Community](https://www.codu.co/) | A space for coders. |

## Courses

| Resource | Description |
| :--- | :--- |
| [freeCodeCamp.org](https://freecodecamp.org) | Learn to code for free - build projects - earn certifications. |
| [JavaScript 30](https://javascript30.com/) | 30 days vanilla JS coding challenge |
| [The Odin Project](https://www.theodinproject.com/) | Free full stack curriculum supported by a passionate open source community. |
| [Python Essentials 1 (Beginner)](https://edube.org/study/pe1) | This course is the first in a 2-course series that will prepare you for the PCEP - Certified Entry-Level Python Programmer and PCAP: Certified Associate in Python Programming certification exams. |
| [Udemy] (https://www.udemy.com) | Learn or teach on udemy.com |
| [Test Automation University](https://testautomationu.applitools.com/) | Become a test automation superstar - Free! |
| [edX](https://www.edx.org/) | Fuel your ambition - explore 4000+ courses |
| [Scrimba](https://scrimba.com/) | Frontend career path helps motivated students become hireable developers for the fraction of the cost of a bootcamp |

## CSS

### CSS Animation

| Resource | Description |
| :--- | :--- |
| [animista](https://animista.net/) | On-demand CSS Animations Library |
| [cubic-bezier](https://cubic-bezier.com/) | Import and Export curves |
| [Easings](https://easings.net/) | Easings helps you find the right easing function |
| [Keyframes](https://keyframes.app/animate) | Keyframe animations |

### CSS Frameworks

| Resource | Description |
| :--- | :--- |
| [Bootstrap](https://getbootstrap.com/) | Build fast, responsive sites with Bootstrap |
| [tailwindcss](https://tailwindcss.com/) | Rapidly build modern websites without ever leaving your HTML. |
| [Bulma](https://bulma.io/) | Bulma: the modern CSS framework that just works. |
| [Zurb Foundation](https://get.foundation/) | The most advanced responsive front-end framework in the world. |
| [Materialize](https://materializecss.com/) | A modern responsive front-end framework based on Material Design |
| [tailwindcomponents](https://tailwindcomponents.com/) | A free repository for community components using Tailwind CSS |
| [Tailblocks](https://tailblocks.cc/) | Ready-to-use Tailwind CSS blocks |
| [tailwindUI](https://tailwindui.com/components) | Tailwind UI Components |
| [Tailwind Cheat-Sheet](https://nerdcave.com/tailwind-cheat-sheet) | Cheat sheet for tailwind |

### CSS Tools

| Resource | Description |
| :--- | :--- |
| [Box Shadows](https://box-shadow.dev/) | customise box shadows |
| [CSS Arrow Please](https://cssarrowplease.com/) | Create and export CSS code for a custom box with an arrow extending out from the side. Great for tooltips, flyouts and the like. |
| [CSS GRID](https://cssgrid.io/) | Learn CSS Grid with Wes Bos in 25 pretty good videos |
| [cssmastery](https://estelle.github.io/cssmastery/#slide1) | CSS Mastery slideshow presentation |
| [CSS Button Generator](http://css3buttongenerator.com) | CSS Button Generator |
| [CSS clip-path Maker](https://bennettfeely.com/clippy/) | CSS Clip Path Maker |
| [Custom Shape Dividers](https://www.shapedivider.app/) | Custom Shape Dividers |
| [Fancy-Border-Radius](https://9elements.github.io/fancy-border-radius/) | Create fancy border radius |
| [flexbox](https://flexbox.io/) | A simple, free 20 video course that will help you master CSS Flexbox! |
| [Glassmorphism.com](https://glassmorphism.com/) | Create glass effect panels |
| [Houdini.how](https://houdini.how/) | How to codepens |
| [Neumorphism.io](https://neumorphism.io/) | Generate Soft-UI CSS code |

### Database

| Resource | Description |
| :--- | :--- |
| [Fauna](https://fauna.com/) | A distributed document-relational database delivered as a cloud API |
| [Firebase](https://firebase.google.com/) | Firebase is an app development platform that helps you build and grow apps and games users love. Backed by Google and trusted by millions of businesses around the world. |
| [HarperDB](https://harperdb.io/) | Combine your database, API, and distribution logic into a single solution for faster time to market, near-zero global latency, and lower total cost of ownership. |
| [MongoDB](https://www.mongodb.com/) | Build applications on the industry's first developer data platform. From AI-powered and event-driven apps to edge use cases and search, build fast and at the scale users demand. |
| [Supabase](https://supabase.com/) | Supabase is an open source Firebase alternative. |
| [ElephantSQL](https://www.elephantsql.com/) | Perfectly configured and optimized PostgreSQL databases ready in 2 minutes. |

## Design

### Audio

| Resource | Description |
| :--- | :--- |
| [Audio Micro](https://www.audiomicro.com/free-sound-effects/) | Royalty Free audio & sound effects |
| [Zapsplat](https://www.zapsplat.com/) | Royalty Free music tracks & sound effects |

### Colors

| Resource | Description |
| :--- | :--- |
| [0to255](https://www.0to255.com/) | 0to255 is a color tool that makes it easy to find lighter and darker colors, also called tints and shades, based on any color. This makes it perfect to use for button hover states, gradients, borders, and more. |
| [Adobe Color Wheel](https://color.adobe.com/create/color-wheel) | Browse and search themes |
| [Colordot by Hail Pixel](https://color.hailpixel.com/) | Choose a random color palette |
| [Colormind.io](http://colormind.io/) | Selection of pre-generated color palettes |
| [Colors.lol](https://colors.lol/) | Overly descriptive color palettes. |
| [Coolors](https://coolors.co/) | The super fast color palettes generator! |
| [Colorsandfonts](https://www.colorsandfonts.com/) | Color and typography inspiration for Web Developers and Digital Designers |
| [Flatuicolors](https://flatuicolors.com/) | Flat UI Colors 2 features 13 more color palettes. Collaborating with 13 designers around the world, a total set of 280 colors are on your command for COPY / PASTE for your next project, design, presentation. |
| [Huemint](https://huemint.com/) | Utilises machine learning to create unique colour schemes. |
| [Mycolor.space](https://mycolor.space/) | Never waste Hours on finding the perfect Color Palette again!  |
| [Paletton](https://paletton.com/) | Creates color palette from a selected color |
| [Stylify Me](http://stylifyme.com) | Get Color Palette from Websites |

### Fonts

| Resource | Description |
| :--- | :--- |
| [ColorAndFonts](https://www.colorsandfonts.com/) | Color and typography inspiration for Web Developers and Digital Designers |
| [Font Flipper](https://fontflipper.com/) | Add typography to an image |
| [Fontjoy](https://fontjoy.com/) | Font pairing made simple |
| [Google Fonts](https://fonts.google.com) | Fonts available from Google |
| [FontPair](https://fontpair.co/) | Free fonts and font pairings to use for your next design project |

### Gradients

| Resource | Description |
| :--- | :--- |
| [CSS Gradient](https://cssgradient.io/) | Create free gradient backgrounds for your website |
| [uiGradients](https://uigradients.com/) | Create a gradient |

### Icons

| Resource | Description |
| :--- | :--- |
| [Bootstrap Icons](https://icons.getbootstrap.com/) | Free, high quality, open source icon library with over 2,000 icons. Include them anyway you like—SVGs, SVG sprite, or web fonts |
| [flaticon](http://www.flaticon.com/) | Access 11.7M+ vector icons & stickers |
| [Feather](https://feathericons.com/) | Simply beautiful open source icons |
| [Font Awesome](https://fontawesome.com/) | Font Awesome is the Internet's icon library and toolkit, used by millions of designers, developers, and content creators. |
| [Heroicons](https://heroicons.dev/) | MIT-licensed open source icons by Steve Schoger |
| [Iconfinder](https://www.iconfinder.com) | Millions of graphics for your design projects. Created by independent designers.  |
| [Material Icons](https://fonts.google.com/icons) | Material Symbols are our newest icons consolidating over 3,062 glyphs in a single font file with a wide range of design variants. Symbols are available in three styles and four adjustable variable font styles (fill, weight, grade, and optical size). |
| [Simple Icons](https://simpleicons.org/) | 2734 Free SVG icons for popular brands |
| [UseAnimations](https://useanimations.com/) | Animated icons in Lottie Framework for immediate implementation to your apps or websites. |
| [Lucide](https://lucide.dev/) | Beautiful & consistent icon toolkit made by the community. |   

### Illustrations

| Resource | Description |
| :--- | :--- |
| [404 Illustrations](https://error404.fun/) | Royalty free illustrations for 404 pages |
| [Control Illustrations](https://control.rocks/) | Combo set of 108 customizable illustrations |
| [DrawKit](https://www.drawkit.io/) | Hand-drawn 2D & 3D illustrations, icons and animations. Perfect for your next project. |
| [LottieFiles](https://lottiefiles.com/) | Lightweight, scalable animations |
| [Open Doodles](https://www.opendoodles.com/) | A Free Set of Open-Source Illustrations! |
| [smash illustrations](https://usesmash.com/) | Awesome illustration constructor with colorful and trendy characters |
| [unDraw Illustrations](https://undraw.co/illustrations) | Browse to find the images that fit your needs and click to download. Use the on-the-fly color image generation to match your brand identity. |

### Inspiration

| Resource | Description |
| :--- | :--- |
| [Awwwards](https://www.awwwards.com/) | The awards that recognize the talent and effort of the best web designers, developers and agencies in the world. |
| [Behance](https://www.behance.net/) | Search the creative world at work |
| [Dribbble](https://dribbble.com/) | Connect with a community of millions of top-rated designers & agencies around the world. |

### Patterns

| Resource | Description |
| :--- | :--- |
| [Hero Patterns](https://www.heropatterns.com/) | A collection of repeatable SVG background patterns for you to use on your web projects. |
| [pattern.css](https://bansal.io/pattern-css) | CSS only library to fill your empty background with beautiful patterns. |
| [Patternico](https://patternico.com/) | Create a background using emoji and colour |
| [Subtle Patterns](https://www.toptal.com/designers/subtlepatterns/) | Background patterns |

### Photos

| Resource | Description |
| :--- | :--- |
| [freepik](https://www.freepik.com) | Create great designs, faster  |
| [Pixabay](https://pixabay.com/) | Stunning royalty-free images & royalty-free stock |
| [Pexels](https://www.pexels.com) | The best free stock photos, royalty free images & videos shared by creators. |
| [Unsplash](https://unsplash.com/) | The internet’s source for visuals. Powered by creators everywhere. |

## Developer Tools

| Resource | Description |
| :--- | :--- |
| [Visual Studio Code](https://code.visualstudio.com/) |Code editing. Redefined. Free. Built on open source. Runs everywhere. |
| [Postman](https://www.postman.com/) | API Testing Client |
| [Insomnia](https://insomnia.rest/) | API Testing Client |
| [WireMock Cloud](https://app.wiremock.cloud/) | API Mocking Web App |
| [Frontend Checklist](https://frontendchecklist.io/) | The Front-End Checklist Application is perfect for modern websites and meticulous developers! |
| [iHateRegex](https://ihateregex.io/) | Regex Cheat Sheet |
| [Pastebin](https://pastebin.com) | Share snippets |
| [GitHub](https://github.com) | GitHub is where over 100 million developers shape the future of software, together. |
| [Grammarly](https://app.grammarly.com/) | Instantly generate clear, compelling writing while maintaining your unique voice. |
| [Stack Overflow](https://stackoverflow.com/) | Every developer/data scientist/system admin/mobile developer/game developer has a tab open to Stack Overflow |

### Authentication

| Resource | Description |
| :--- | :--- |
| [Auth0](https://auth0.com/) | Secure access for everyone but not just anyone |

### Chrome Extensions

| Resource | Description |
| :--- | :--- |
| [CSSViewer](https://chrome.google.com/webstore/detail/cssviewer/ggfgijbpiheegefliciemofobhmofgce?hl=en) | A simple CSS property viewer. |
| [ColorZilla](https://chrome.google.com/webstore/detail/colorzilla/bhlhnicpbhignbdhedgjhgdocnmhomnp?ref=designrevision.com) | Advanced Eyedropper, Color Picker, Gradient Generator and other colorful goodies |
| [Gitpod](https://chromewebstore.google.com/detail/gitpod/dodmmooeoklaejobgleioelladacbeki?hl=en) | Go from repository to developer environment in a click |
| [JSON Viewer](https://chrome.google.com/webstore/detail/json-viewer/gbmdgpbipfallnflgajpaliibnhdgobh) | The most beautiful and customizable JSON/JSONP highlighter that your eyes have ever seen. |
| [React Developer Tools](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi) | React Developer Tools is a Chrome DevTools extension for the open-source React JavaScript library. It allows you to inspect the React component hierarchies in the Chrome Developer Tools. |
| [Wappalyzer](https://chrome.google.com/webstore/detail/wappalyzer/gppongmhjkpfnbhagpmjfkannfbllamg) | Wappalyzer is a technology profiler that shows you what websites are built with. |
| [WAVE Evaluation Tool](https://chrome.google.com/webstore/detail/wave-evaluation-tool/jbbplnpkjmmeebjpijfedlgcdilocofh) | Evaluate web accessibility within your browser. |
| [Web Disability Simulator](https://chrome.google.com/webstore/detail/web-disability-simulator/olioanlbgbpmdlgjnnampnnlohigkjla/) | Simulates how people with disabilities experience the web |
| [Webpage Spell-Check](https://chrome.google.com/webstore/detail/webpage-spell-check/mgdhaoimpabdhmacaclbbjddhngchjik) | Instant spell-check on any web page |
| [WhatFont](https://chrome.google.com/webstore/detail/whatfont/jabopobgcpjmedljpbcaablpmlmfcogm?hl=en) | The easiest way to identify fonts on web pages. |

### Domain Name

| Resource | Description |
| :--- | :--- |
| [namecheap](https://www.namecheap.com/) | Domain names, hosting, email, marketing tools, security & wordpress |

### Generators

| Resource | Description |
| :--- | :--- |
| [Django Secret Key Generator](https://miniwebtool.com/django-secret-key-generator/) | Django secret key generator |
| [mockaroo](https://mockaroo.com/) | Data Generator |
| [JSON Generator](https://next.json-generator.com/) | Data Generator |
| [Favicon Generator](https://realfavicongenerator.net/) | Favicon Generator. |
| [Free Favicon Maker](https://formito.com/tools/favicon) | Free favicon maker |
| [Online UUID Generator](https://www.uuidgenerator.net/) | Online UUID generator |
| [Meta Tags](https://metatags.io/) | Meta tags toolkit - preview, edit and generate |
| [carbon](https://carbon.now.sh/) | Code Snippet Image |

### Hosting

| Resource | Description |
| :--- | :--- |
| [Netlify](https://www.netlify.com/) | connect everything - build anything |
| [Surge](https://surge.sh/) | Static web publishing for front-end developers |
| [Vercel](https://vercel.com/) | We enable developers to build and publish wonderful things. We build products for developers and designers. And those who aspire to become one. |
| [Render](https://render.com/docs/free) | The fastest way to host all your code, API, cron jobs, web apps, databases... |
| [Kinsta](https://kinsta.com/static-site-hosting/) | Deploy up to 100 static sites for free, custom domains with SSL, 100 GB monthly bandwidth, 260+ Cloudflare CDN locations. |

### Optimization

| Resource | Description |
| :--- | :--- |
| [Birme](https://www.birme.net/) | Bulk image resizer |
| [Minify](http://minifier.org) | Code minifier |
| [tinypng](https://tinypng.com/) | Image compression |
| [Compressor](https://compressor.io/) | Image compression |
| [Measure](https://web.dev/measure/) | Metrics |
| [Lighthouse Metrics](https://lighthouse-metrics.com/) | Metrics |

### Online Code Editors

| Resource | Description |
| :--- | :--- |
| [CodePen](https://codepen.io) | The best place to build, test and discover front-end code |
| [JSFiddle](https://jsfiddle.net) | Online code editor for HTML, CSS and JS |
| [Liveweave](http://liveweave.com) | Online code editor for HTML, CSS and JS |
| [repl.it](https://repl.it) | online code editor |
| [JS Bin](https://jsbin.com/) | Online code editor for HMTL, CSS and JS |
| [CodeSandbox](https://codesandbox.io/) | online code editor for a variety of languages |

### Project Management

| Resource | Description |
| :--- | :--- |
| [Notion](https://www.notion.so/product) | Notion is the connected workspace where better, faster work happens. Now with AI  |
| [Trello](https://trello.com/) | Trello brings all your tasks, teammates, and tools together |
| [PerfectBugReport.io](https://www.perfectbugreport.io/) | A simple checklist of essential items to include in bug reports. |

### Validation

| Resource | Description |
| :--- | :--- |
| [Can I Use](https://caniuse.com/) | Browser Compatibility Lookup |
| [ECMAScript Compatibility Table](https://kangax.github.io/compat-table/es6/) | ECMAScript compatibility table |

## Newsletters

| Resource | Description |
| :--- | :--- |
| [Bytes](https://bytes.dev/) | Staying informed on the JavaScript ecosystem has never been so entertaining. Delivered every Monday and Thursday, for free. |
| [CSS Tricks Newsletter](https://css-tricks.com/newsletter/) | An email newsletter with the most interesting news, ideas, fresh content, thoughts, and incredibly mature jokes from Team CSS-Tricks. This is your ticket to saying up to date with web dev. |
| [CSS Weekly](https://css-weekly.com/) | Weekly e-mail roundup of CSS articles, tutorials, experiments, and tools curated by Zoran Jambor |
| [JavaScript Weekly](https://javascriptweekly.com/) | A newsletter of JavaScript articles, news and cool projects |
| [Frontend Focus](https://frontendfoc.us) | A once–weekly roundup of the best front-end news, articles and tutorials. HTML, CSS, WebGL, Canvas, browser tech, and more. |
| [7.dev](https://7.dev/) | Learn to program with our tutorials and courses |
| [Flexbox Adventure](https://flexboxadventure.com/) | No more boring videos, tutorials and courses. Learn Flex Box in a completely new, fun, effective and revolutionary way. By playing Flex Box coding game! |

## Podcasts

| Resource | Description |
| :--- | :--- |
| [Developer Tea](https://developertea.com/) | A podcast by Jonathan Cutrell, empowering developers to discover their purpose, excel at work, and create a positive impact. |
| [Front End Happy Hour](https://frontendhappyhour.com/) | A software engineering podcast featuring a panel of Software Engineers from Netflix, Twitch, & Atlassian talking over drinks about Frontend, JavaScript, and career development. |
| [Full Stack Radio](https://fullstackradio.com/) | A podcast for developers interested in building great software products. Hosted by Adam Wathan. |
| [JS Party](https://changelog.com/jsparty) | Welcome to JS Party, a weekly celebration of JavaScript and the web |
| [Ladybug Podcast](https://www.ladybug.dev/) | We’re debugging the tech industry. |
| [The Scrimba Podcast](https://scrimba.com/podcast/) | A weekly pod about learning to code and how to get your first junior developer job |
| [Software Engineering Radio](https://www.se-radio.net) | The Podcast for Professional Software Developers |
| [Syntax.fm](https://syntax.fm) | A tasty treats podcast for Web Developers |
| [How to Program with Java Podcast](https://howtoprogramwithjava.libsyn.com/) | Learn how to program using the Java programming language |

## Practice

| Resource | Description |
| :--- | :--- |
| [Frontend Mentor](https://www.frontendmentor.io/) | Improve your front-end coding skills by building real projects |
| [CodeWars](https://www.codewars.com/) | Train code problems |
| [30 Day Vanilla JS Coding Challenge](https://javascript30.com/) | 30 day vanilla JS coding challenge |
| [SQLBolt](https://sqlbolt.com/) | A series of interactive lessons and exercises designed to help you quickly learn SQL right in your browser. |
| [iCodeThis](https://icodethis.com/) | Daily projects you can build to improve your coding skills! |
| [SQL ZOO](https://sqlzoo.net/wiki/SQL_Tutorial)                 | SQLZoo is an interactive online learning platform that offers tutorials and exercises on SQL queries and database management, helping users improve their SQL skills. |

## YouTube Channels

### General web development knowledge

| Resource | Description |
| :--- | :--- |
| [Ahmad Awais](https://www.youtube.com/channel/UCKJPVjhsLfzh1cJrUFF9jQg) | Learn with Awais |
| [Ben Awad](https://www.youtube.com/channel/UC-8QAzbLcRglXeN_MY9blyw) | Videos about React, React Native, GraphQL, Typescript, Node.js, PostgreSQL, Python, and all things coding. |
| [Better Dev](https://www.youtube.com/channel/UCmXVXfidLZQkppLPaATcHag) | CSS videos |
| [Claudio Bernasconi](https://www.youtube.com/channel/UCTbHPk0bIOQwTXuGgD195bw) | Become a better (.NET) Software Engineer by improving your developer skills. It's hard to stand out as a developer. Make yourself the best version you can be. |
| [CodeDamn](https://www.youtube.com/channel/UCJUmE61LxhbhudzUugHL2wQ) | Videos mostly related to programming, and sometimes simple hacks and tricks to survive on internet! |
| [CoderOne](https://www.youtube.com/channel/UCMm15RFnHUvM-aSc50e7R9A) | CoderOne is a Learning Channel For Web Development, Software Enginnering and Coding All in one place with a High quality Video/Written Tutorials along side a Learning Platform that allows you to dig deep and learn everything that comes new. |
| [codeSTACKr](https://youtube.com/codeSTACKr) | Tutorials about web development and include coding languages such as HTML, CSS, Sass, JavaScript, and TypeScript |
| [Codevolution](https://www.youtube.com/channel/UC80PWRj_ZU8Zu0HSMNVwKWw) | Tutorials on the latest tech in web development! |
| [Code with Ania Kubów](https://www.youtube.com/channel/UC5DNytAJ6_FISueUfzZCVsw) | Want to learn how to code from nothing? I will show you how! |
| [Coding Garden](https://www.youtube.com/channel/UCLNgu_OupwoeESgtab33CCw) | Coding Garden is an open, interactive and engaging community where any coder, from beginner to veteran, can learn and grow together. |
| [Coding Addict](https://www.youtube.com/c/CodingAddict) | Video courses on web development |
| [Codú Community](https://www.youtube.com/channel/UCvI5azOD4eDumpshr00EfIw) | With a mix of short videos and long-form workshops, I hope it can help you become a better developer. |
| [Colby Fayock](https://www.youtube.com/channel/UC7Wpv0Aft4NPNhHWW_JC4GQ) | I help others get the tech out of the way to solve real problems with the tools of the web |
| [Dave Gray](https://www.youtube.com/channel/UCY38RvRIxYODO4penyxUwTg) | Web Development tutorials with full courses on HTML, CSS, JavaScript, React, Node.js and more! |
| [dcode](https://www.youtube.com/channel/UCjX0FtIZBBVD3YoCcxnDC4g) | High quality web development tutorials. |
| [Dennis Ivy](https://www.youtube.com/channel/UCTZRcDjjkVajGL6wd76UnGg) | Sharing what I know about Full Stack Web development with the primary Focus being Python, Django & Javascript at the time. I will be creating Project based tutorials for these Languages/Frameworks/Libraries along with sharing my personal experience. |
| [Dev Ed](https://www.youtube.com/channel/UClb90NQQcskPUGDIXsQEz5Q) | Your go-to channel for learning how to code, design, and become more creative in the tech world! |
| [Faraday Academy](https://www.youtube.com/channel/UCxA99Yr6P_tZF9_BgtMGAWA) | I make videos about topics related to what I am working on at work, currently studying, or how I am trying to improve my productivity as a developer. I try to share any interesting or useful knowledge as much as I can on this channel |
| [Fireship](https://www.youtube.com/channel/UCsBjURrPoezykLs9EqgamOA) | High-intensity ⚡ code tutorials and tech news to help you ship your app faster. New videos every week covering the topics every programmer should know.  |
| [freeCodeCamp.org](https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ) | Learn to code for free |
| [Harry Wolff](https://www.youtube.com/channel/UCgdeMp2ZBnovi12THmLc47g) | Every week I post a new video to share my love and joy of JavaScript and all things web related. |
| [James Perkins](https://www.youtube.com/channel/UC-zet8Eyyy-OUE_fmocp3Wg) | Subscribe if you learn about next.js, typescript, and more. |
| [James Q Quick](https://www.youtube.com/channel/UC-T8W79DN6PBnzomelvqJYw) | I publish weekly videos about Web Development! |
| [JavaScript Mastery](https://www.youtube.com/channel/UCmXmlB4-HJytD7wek0Uo97A) | Master modern web development with a project-based approach |
| [Josh tried Coding](https://www.youtube.com/@joshtriedcoding) | Hi. I'm Josh and my goal is to have fun creating stuff and sharing that here on youtube. It's nice to have you here! |
| [Lama Dev](https://www.youtube.com/@LamaDev) | Web development tutorials for everyone. Learn JavaScript, React.js, Node.js, and find inspiration for HTML, CSS, and web design with Lama and become a web developer. |
| [Leigh Halliday](https://www.youtube.com/channel/UCWPY8W-FAZ2HdDiJp2RC_sQ) | Tutorials about JavaScript and React. |
| [Programming with Mosh](https://www.youtube.com/channel/UCWv7vMbMWH4-V0ZXdmDpPBA) | I train professional software engineers that companies love to hire. |
| [Program With Erik](https://www.youtube.com/channel/UCshZ3rdoCLjDYuTR_RBubzw) | I do tutorials, advice and occasionaly I vlog! |
| [Tech With Tim](https://www.youtube.com/channel/UC4JX40jDee_tINbkjycV4Sg) | Learn programming, software engineering, machine learning and everything tech from this channel.  |
| [The Net Ninja](https://www.youtube.com/channel/UCW5YeuERMmlnqo4oq8vwUpg) | Black belt your development skills with over 2,000 free programming tutorials. |
| [Traversy Media](https://www.youtube.com/channel/UC29ju8bIPH5as8OGnQzwJyA) | Traversy Media features the best online web development and programming tutorials for all of the latest web technologies from the building blocks of HTML, CSS & JavaScript to frontend frameworks like React and Vue to backend technologies like Node.js, Python and PHP |
| [Web Dev Simplified](https://www.youtube.com/channel/UCFbNIlppjAuEX4znoulh0Cw) | Web Dev Simplified is all about teaching web development skills and techniques in an efficient and practical manner. If you are just getting started in web development Web Dev Simplified has all the tools you need to learn the newest and most popular technologies to convert you from a no stack to full stack developer. |

### Frontend YT

| Resource | Description |
| :--- | :--- |
| [Adrian Twarog](https://www.youtube.com/channel/UCvM5YYWwfLwpcQgbRr68JLQ) | Coding & Tutorials - Design & Inspiration - UX & UI |
| [Coder Coder](https://www.youtube.com/thecodercoder) | Practical tips for the beginner web developer. |
| [DesignCourse](https://www.youtube.com/channel/UCVyRiMvfUNMA1UPlDPzG5Ow) | Learn UI/UX and CSS with my custom interactive courses |
| [Kevin Powell](https://www.youtube.com/channel/UCJZv4d5rbIKd4QHMPkcABCw) | Helping you learn how to make the web, and make it look good while you're at it. |
| [ColorCode](https://www.youtube.com/@ColorCodeio/) | Coding Tutorials for regular people! |

### Career YT

| Resource | Description |
| :--- | :--- |
| [Chris Sean](https://www.youtube.com/channel/UCu1xbgCV5o48h_BYCQD7KJg) | Videos about becoming a web developer |
| [CodeStories](https://www.youtube.com/channel/UCqNNNJWqW-0bOziAeSMem9Q) | The channel where IT professionals from all disciplines and from all over the globe come to share their stories to encourage, equip, empower, and inspire you. |
| [Dorian Develops](https://www.youtube.com/channel/UCUOMtzQmEmhIAF8G_cha_Xw) | Various career advice videos |
| [DThompsonDev](https://www.youtube.com/channel/UC8ha68gfkmh5v2a2BAx7low) | Career advise for those wanting to break into the software industry |
| [Eddie Jaoude](https://www.youtube.com/channel/UC5mnBodB73bR88fLXHSfzYA) | Videos about open source |
| [ForrestKnight](https://www.youtube.com/channel/UC2WHjPDvbE6O328n17ZGcfg) | My humble attempt at building my version of the digital world one step at a time by creating programming and computer science content to help those coming behind me.|
| [Joshua Fluke](https://www.youtube.com/channel/UC-91UA-Xy2Cvb98deRXuggA) | Videos about life and the realities of the corporate world |
| [Randall Kanna](https://www.youtube.com/channel/UCqC9s1NAkvPidFpGBewPs2w) | Career videos  |
| [RealToughCandy](https://www.youtube.com/channel/UC54NcJvLCvM2CNaBjd5j6HA) | Coding course & platform reviews - Web development news - Freelancing advice and more! |

### DevOps YT

| Resource | Description |
| :--- | :--- |
| [Amigoscode](https://www.youtube.com/@amigoscode) | Premium programming courses. |
| [DevOps Directive](https://www.youtube.com/channel/UC4MdpjzjPuop_qWNAvR23JA) | Provide educational and entertaining content to enable engineers to level up their skills and keep up with the continuously evolving DevOps and Cloud Infrastructure landscape. |
| [DanGitschooldude](https://www.youtube.com/c/DanGitschooldude) | This channel is dedicated to teaching the distributed version control system git. |
| [TechWorld with Nana](https://www.youtube.com/channel/UCdngmbVKX1Tgre699-XLlUA) | Helping people to learn DevOps topics easily 💙 |

### Mobile YT

| Resource | Description |
| :--- | :--- |
| [Flutter Explained](https://www.youtube.com/channel/UCgUnLn1FpuHHmO66vn4o1NA) | This channel should be the Wikipedia for Flutter development, and for all questions related to Flutter, it should be possible to find an answer here. |
| [William Candillon](https://www.youtube.com/channel/UC806fwFWpiLQV5y-qifzHnA) | React Native Tutorials |

### Blockchain YT

| Resource | Description |
| :--- | :--- |
| [EatTheBlocks](https://www.youtube.com/channel/UCZM8XQjNOyG2ElPpEUtNasA) | On EatTheBlocks, I help you to become a Web3 expert, so that you can make more money, gain more freedom, and work on projects you love. I cover Ethereum, Solidity, smart contract security, Dapps, DeFi, NFTs. |

### Backend YT

| Resource | Description |
| :--- | :--- |
| [Caleb Curry](https://www.youtube.com/channel/UCZUyPT9DkJWmS_DzdOi7RIA) | Programming Made Fun and Simple. High quality tutorials that are fun, educational, and easy to follow. |
| [CodeBeauty](https://www.youtube.com/channel/UCl5-BV9aRaeDVohpE4sqJiQ) | These videos are intended to help you to get a job, learn for your exams, learn to program for fun, and answer your questions about software engineering. |
| [Python Engineer](https://www.youtube.com/channel/UCbXgNpp0jedKWcQiULLbDTA) | Free Python and Machine Learning Tutorials! |
