import { defineConfig, devices } from "@playwright/test";

/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
// require('dotenv').config();

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
  globalSetup: "./e2e/setup.ts",
  globalTeardown: "./e2e/teardown.ts",
  testDir: "e2e",
  /* Run tests in files in parallel */
  fullyParallel: true,
  /* Fail the build on CI if you accidentally left test.only in the source code. */
  forbidOnly: !!process.env.CI,
  /* Retry on CI only */
  retries: process.env.CI ? 2 : 0,
  /* Opt out of parallel tests on CI. */
  workers: process.env.CI ? 3 : undefined,
  /* Reporter to use. See https://playwright.dev/docs/test-reporters */
  reporter: "html",
  /* Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions. */
  use: {
    /* Base URL to use in actions like `await page.goto('/')`. */
    // baseURL: 'http://127.0.0.1:3000',

    /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
    trace: "on-first-retry",
  },
  expect: {
    timeout: 10000,
  },

  /* Configure projects for major browsers */
  projects: [
    { name: "setup", testMatch: /auth.setup\.ts/ },
    {
      name: "Desktop Chrome",
    },

    // Example other browsers
    {
      name: "Desktop Firefox",
      use: {
        ...devices["Desktop Firefox"],
      },
    },
    {
      name: "Mobile Chrome",
      use: {
        ...devices["Pixel 9"],
      },
    },
    {
      name: "Mobile Safari",
      use: {
        ...devices["iPhone 16"],
      },
    },
  ],

  outputDir: "playwright-report",

  /* Run your local dev server before starting the tests */
  webServer: {
    command: "npm run dev:e2e",
    url: "http://127.0.0.1:3000",
    reuseExistingServer: !process.env.CI,
  },
});
