This series is a starter guide to React. By the end of the series you should be able to start building applications with React.js.

## What is React?

_React is a JavaScript UI library._

The React library first appeared in May 2013 and is now one of the most commonly used front-end libraries with no sign of slowing down.

How popular? Check out [this list](https://trends.builtwith.com/websitelist/React) on BuiltWith, which has millions of apps using React.

React has a small API, and you need to know only a handful of concepts to start being productive:

* Components
* JSX
* Styling
* State
* Props
* Effects

We will cover all of these concepts in this series, and by the end, you should be able to create your first small applications in React from scratch. 

You might initially find learning React hard, but once you understand some of the fundamentals, it'll be one of the best developer experiences.

Be patient, practice, and you'll be rewarded!

## A very brief history

Facebook (and, more specifically, a Facebook employee named Jordan Walke) started developing it as they faced issues with code maintenance in 2011\.

It was then open-sourced and made available in 2013, where we have seen it co-developed by Facebook and the open-source community ever since. 

## Benefits of using React

Before you dive into React, I think it's worth understanding some of the benefits of using a tool like React.

Here are some of the highlights:

**Reusable components:** React's component-based architecture promotes code reusability, making it easier to maintain, scale, and update applications. This reuse makes developers much more productive since they can share common patterns and components throughout an application. 

**Improved performance:** React's virtual DOM implementation reduces the need for frequent DOM manipulation, resulting in faster and more efficient rendering of user interfaces.

**Strong community:** React has a large and active community of developers, which has resulted in a wealth of tutorials, libraries, and third-party tools available for use in React projects. If you get stuck, you are very likely to find a solution on the internet for someone trying to solve the same problem.

**Cross-platform development:** This is a bonus that I really like. With React Native, developers can use React to build native mobile applications for iOS and Android platforms.

## Prerequisites

We assume you are familiar with HTML, CSS, and JavaScript for this series.

If you're knowledgeable in JavaScript, React should be relatively easy to get the hang of. This can often take years, so don't let it deter you if you are dying to jump in and start with React.

Here's a list of the JavaScript topics you should be comfortable with to get the most from the series:

* Variables and data types
* Control structures (if-else, loops)
* Functions (including arrow functions)
* Callback functions
* Arrays and objects
* Array methods (map, filter, reduce)
* Object destructuring and spread operator
* Template literals
* Modules (import, export)
* Promises

These topics will be noteworthy because we will use them within the code examples.

Let's start learning React.js!
