import { Suspense } from "react";
import Link from "next/link";
import Hero from "@/components/Hero/Hero";
import TrendingPosts from "@/components/TrendingPosts/TrendingPosts";
import TrendingLoading from "@/components/TrendingPosts/TrendingPostsLoading";
import SideBarSavedPosts from "@/components/SideBar/SideBarSavedPosts";
import { getServerAuthSession } from "@/server/auth";
import PopularTags from "@/components/PopularTags/PopularTags";
import PopularTagsLoading from "@/components/PopularTags/PopularTagsLoading";
import CoduChallenge from "@/components/CoduChallenge/CoduChallenge";

const Home = async () => {
  const session = await getServerAuthSession();

  return (
    <>
      <div>
        <Hero />
        {session == null && (
          <section className="bg-white px-2 dark:bg-neutral-300" id="cta">
            <div className="mx-auto py-20 sm:max-w-2xl sm:py-32 lg:max-w-5xl">
              <h2 className="max-w-[660px] text-center text-2xl font-semibold tracking-tight text-neutral-900 dark:text-gray-900 sm:text-4xl md:text-left">
                <span className="font-extrabold">Sign up today</span> to become
                a writer and get a <span className="font-extrabold">free</span>{" "}
                invite to our Discord community.
              </h2>
              <div className="mt-8 flex items-center justify-center gap-x-6 md:justify-start">
                <Link href="/get-started" className="primary-button">
                  Get started
                </Link>
                <Link
                  href="/articles/explore-the-benefits-of-being-a-part-of-cod-ety1wehv"
                  className="font-semibold leading-6 text-neutral-900 dark:text-gray-900"
                >
                  Learn more <span aria-hidden="true">→</span>
                </Link>
              </div>
            </div>
          </section>
        )}
      </div>

      <div className="mx-2" id={session ? "cta" : ""}>
        <div className="mt-6 flex max-w-5xl items-center justify-between border-b border-b-neutral-300 pb-2 dark:border-b-neutral-600 sm:mx-auto sm:max-w-2xl lg:max-w-5xl">
          <h3 className="text-3xl font-bold tracking-tight text-neutral-800 dark:text-neutral-50 sm:text-4xl">
            Trending
          </h3>
        </div>
        <div className="mx-auto grid-cols-12 gap-6 sm:max-w-2xl lg:grid lg:max-w-5xl">
          <Suspense fallback={<TrendingLoading />}>
            <TrendingPosts session={session} />
          </Suspense>
          <section className="col-span-5 hidden lg:block">
            <CoduChallenge />
            <h4 className="mb-4 mt-4 text-2xl font-semibold leading-6 tracking-wide">
              Popular topics
            </h4>
            <div className="flex flex-wrap gap-2">
              <Suspense fallback={<PopularTagsLoading />}>
                <PopularTags />
              </Suspense>
            </div>
            {session && (
              <div className="flex flex-wrap gap-2">
                <SideBarSavedPosts />
              </div>
            )}
          </section>
        </div>
      </div>
    </>
  );
};

export default Home;
