# [Dash UI - Bootstrap 5 Theme](https://codescandy.com/dashui/index.html) [![Twitter URL](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Fgithub.com%2Fcodescandy%2FDash-UI)](https://twitter.com/intent/tweet?text=Dash%20-%20UI%20Bootstrap%205%20Theme&url=https%3A%2F%2Fgithub.com%2Fcodescandy%2FDash-UI&via=getcodescandy)

<a href="https://codescandy.com/dashui/index.html">
 <img src="https://github.com/codescandy/Dash-UI/blob/main/src/assets/images/marketing/bootstrap-5-admin-dashboard-template.jpg" alt="Dash UI Bootstrap 5 Theme"/>
</a>

Dash-UI is a Bootstrap 5 Admin & Dashboard Theme. Dash UI Kit a free and open source components and templates kit fully coded with Bootstrap 5.

[Dash UI pro](https://dashui.codescandy.com/)

## Workflow

This product is built using the following widely used technologies:

- Most popular CSS Framework Bootstrap 5
- Productive workflow tool Gulp
- Awesome CSS preprocessor Sass

## Table of Contents

- [Quick Start](#quick-start)
- [Documentation](#documentation)
- [File Structure](#file-structure)
- [Browser Support](#browser-support)
- [Technical Support or Questions](#technical-support-or-questions)
- [Figma design file](#figma-design-file)

## Quick start

1. Download from clone this repository
2. Download the project's zip
3. Make sure you have Node locally installed.
4. Download Gulp Command Line Interface to be able to use gulp in your Terminal.

```
npm install gulp-cli -g
```

5. After installing Gulp, run npm install in the main `dash-ui/` folder to download all the project dependencies. You'll find them in the `node_modules/` folder.

```
npm install
```

6. Run gulp in the `dash-ui/` folder to serve the project files using BrowserSync. Running gulp will compile the theme and open `/index.html` in your main browser.

```
gulp
```

7. Generates a /dist directory with all the production files.

```
gulp build
```

## Documentation

The documentation for Dash UI is provide on our [website](https://codescandy.com/dashui/docs/gulp.html).

## File Structure

Within the download you'll find the following directories and files:

```

Dash UI Bootstrap 5 Theme
.
├── src
    ├── assets
    |   ├── css
    │   ├── fonts
    │   ├── images
    |   ├── js
    │   ├── scss
    |       ├── theme
    |       ├── theme.scss
    ├── pages
    │   ├── 404-error.html
    │   ├── billing.html
    │   ├── forget-password.html
    │   ├── layout.html
    │   ├── pricing.html
    │   ├── profile.html
    │   ├── settings.html
    │   ├── sign-in.html
    │   ├── sign-up.html
    │   └── tables.html
    ├── partials
    │   ├── doc-navbar.html
    │   ├── docs-sidenav.html
    │   ├── head.html
    │   ├── header.html
    │   ├── navbar-vertical.html         
    │   └── scripts.html
    ├── index.html
    ├── gulpfile.js
    ├── package-lock.json
    ├── package.json
    ├── README.md


```

## Browser Support

At present, we officially aim to support the last two versions of the following browsers:

<img src="https://github.com/codescandy/Dash-UI/blob/main/src/assets/images/marketing/chrome.png" width="64" height="64"><img src="https://github.com/codescandy/Dash-UI/blob/main/src/assets/images/marketing/firefox.png" width="64" height="64"><img src="https://github.com/codescandy/Dash-UI/blob/main/src/assets/images/marketing/edge.png" width="64" height="64"><img src="https://github.com/codescandy/Dash-UI/blob/main/src/assets/images/marketing/safari.png" width="64" height="64"><img src="https://github.com/codescandy/Dash-UI/blob/main/src/assets/images/marketing/opera.png" width="64" height="64">

## Technical Support or Questions

If you have questions or need help integrating the product please [contact us](https://codescandy.com/contact-us/). [Support](https://github.com/codescandy/Dash-UI/discussions)

## Useful Links

- [Bootstrap Template](https://dashui.codescandy.com/free-bootstrap-5-admin-dashboard-template.html)
- [React Template](https://dashui.codescandy.com/free-reactjs-admin-dashboard-template.html)
- [Next.js Template](https://dashui.codescandy.com/free-next-js-admin-dashboard-template.html)
- [Nuxt.js Template](https://dashui.codescandy.com/free-nuxt-js-admin-dashboard-template.html)
- [Tailwind Template](https://dashui.codescandy.com/free-tailwindcss-admin-dashboard-html-template.html)

## Figma Design File

Ready to use [Figma File](https://www.figma.com/community/file/1259105309122518026/dash-ui-admin-dashboard-template).

## Upgrade to PRO

Get more power with [Dash UI pro](https://dashui.codescandy.com/) featuring bunch of UI components, forms, tables, charts, pages, and icons.

| Free Version                                                                                  | DashUI PRO                                                                                |
| --------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------- |
| ✔️ 1 Dashboard                                                                                | ✔️ 6 Dashboard                                                                            |
| ✔️ 11 HTML Pages                                                                              | ✔️ 60+ HTML pages                                                                         |
| ✔️ Includine Docs                                                                             | ✔️ Documentation                                                                          |
| ✔️ 4 Plugins                                                                                  | ✔️ 10+ Plugins                                                                            |
| ✔️ Source Files                                                                               | ✔️ Source Files                                                                           |
| ❌ Dark Mode                                                                                  | ✔️ Dark Mode                                                                              |
| ❌ Layout Options                                                                             | ✔️ Layout Variations                                                                      |
| ❌ Priority Support                                                                           | ✔️ Priority Support                                                                       |
| -                                                                                             | ✔️ Free Update                                                                            |
| [Free Download](https://dashui.codescandy.com/free-bootstrap-5-admin-dashboard-template.html) | [Get Dash UI](https://dashui.codescandy.com/bootstrap-admin-dashboard-html-template.html) |
