/*
 * a theme inspired by Muzli && unbuntu
 */
import { lighten, darken } from 'polished'

const primaryColor = '#615c79'

const bannerBg = '#2f2c3c'
const contentBg = '#242029'
const contentBoxBg = '#27232d'
const fontColor = primaryColor
const sidebarBg = '#222029'
const markdownFont = '#7F8189'

const descText = '#514a67'
const primaryMate = '#a7674d'

const purple = {
  _meta: {
    category: 'dark',
  },
  name: 'purple',
  logoText: primaryColor,
  cover: primaryColor,
  coverIndex: '#9e96c3',
  contrastFg: 'orange',
  htmlBg: contentBoxBg,
  spaceBg: '#1a181f',
  mobileTab: bannerBg,
  loading: {
    basic: bannerBg,
    animate: lighten(0.03, bannerBg),
    // basic: '#113B4A',
    // animate: '#02495a',
  },
  error: {
    title: primaryColor,
    desc: darken(0.1, primaryColor),
    bg: lighten(0.02, contentBoxBg),
  },

  font: fontColor,
  link: '#269A95',
  main: '#7DC0C5',
  bodyBg: contentBg,
  selectionBg: '#839496',
  baseColor: {
    red: '#ca5f4d',
    orange: '#ad735c',
    yellow: '#B0BA6C',
    green: '#699411',
    cyan: '#24878C',
    blue: '#456fbd',
    purple: '#7d519e',

    grey: '#106d8a',
    pink: '#b36976',

    pinkLite: '#82606b',
    pinkBtnText: '#ded0d0',
  },
  header: {
    fg: primaryColor,
    bg: bannerBg,
    spliter: darken(0.04, bannerBg),
    fixed: bannerBg,
    tabActive: primaryColor, // articleTitle
    tabOthers: darken(0.1, primaryColor),
    cardBg: '#2a2835',
    cardBorder: '#55516b',
    cardLogoText: '#57526f',
    cardTitle: '#615c7a',
  },
  banner: {
    title: primaryColor,
    bg: bannerBg,
    desc: descText,
    spliter: darken(0.04, bannerBg),
    number: primaryColor,
    active: primaryMate,
    numberDesc: descText,
    numberDivider: darken(0.08, descText),
    numberHoverBg: lighten(0.03, bannerBg),
  },
  thread: {
    bg: contentBoxBg,
    filterResultHint: descText,
    articleTitle: '#737990',
    articleStrip: contentBoxBg,
    articleDigest: '#505667',
    articleTag: '#526482',
    articleLink: descText,
    articleDivider: '#3b3444',
    commentsUserBorder: contentBoxBg,
    extraInfo: primaryMate,
    articleSpliter: '#3f3a50',
    // like github
    repoTitle: '#737990',
  },
  content: {
    bg: contentBoxBg,
    border: contentBoxBg,
    cardBg: bannerBg,
    cardBorder: lighten(0.08, contentBoxBg),
    cardBorderHover: lighten(0.1, contentBoxBg),
  },
  footer: {
    text: descText,
    hover: lighten(0.1, descText),
    title: '#77706B',
    bottomBg: '#1f1d1f',
  },
  sidebar: {
    bg: sidebarBg,
    activeBar: '#988ac1',
    holder: lighten(0.15, sidebarBg),
    logoText: primaryColor,
    menuHover: lighten(0.1, sidebarBg),
    pinActive: '#92584a',
    menuLink: '#9a96b1',
    borderColor: lighten(0.05, sidebarBg),
    headerShadow: '-2px 1px 6px 0px rgb(1,21,25)',
    headerShadowBorderBottom: '1px solid #615b79',
    footerShadow: '-1px -4px 4px 0px rgb(1,21,25)',
    footerShadowBorderBottom: '1px dashed #615b79',
    searchInputBottom: '#3A3948',
    searchInputBottomActive: '#5F5C75',
    searchInputHolder: '#3B3948',
  },
  drawer: {
    title: primaryColor,
    desc: lighten(0.05, descText),
    font: fontColor,
    bg: contentBoxBg,
    shadow: '-5px 0px 14px 0px rgba(41, 18, 18, 0.19)',
    closerShadow: '-5px 0px 14px 0px rgba(41, 18, 18, 0.19)',
    markdownHelperBg: lighten(0.04, contentBg),
    accountBg: lighten(0.04, contentBg),
    articleBg: lighten(0.04, contentBg),
    helper: lighten(0.2, contentBg),
    helperHover: lighten(0.3, contentBg),
    topLine: '#c387e8',
    icon: '#845145',
    divider: darken(0.07, descText),
    /* single article page sidebar divider */
    sideDivider: '#413d54',
  },
  article: {
    link: primaryMate,
    linkHover: lighten(0.05, primaryMate),
    reactionTitle: primaryColor,
    reactionHoverBg: lighten(0.04, contentBg),
  },
  comment: {
    bg: '#28262d',
    icon: primaryColor,
    didIcon: primaryMate,
    title: primaryColor,
    username: primaryColor,
    number: primaryMate,
    floor: primaryMate,
    reply: primaryColor,
    replyBg: '#3d3644',
    placeholder: descText,
    filter: descText,
    filterActive: primaryColor,
    action: darken(0.1, primaryColor),
    // mention text displayed in article
    mentionText: '#70768B',
    mentionTextBg: '#423a4a',
    // mention popover background
    mentionBg: contentBoxBg,
    mentionBorder: primaryColor,
    mentionActiveBg: lighten(0.1, contentBoxBg),
    mentionShadow: '0px 2px 10px 1px rgba(47, 46, 46, 0.8)',

    indentLine: '#035163',
    indentActive: '#4b6669',
  },
  editor: {
    title: primaryColor,
    content: '#6E717A',
    placeholder: darken(0.03, descText),
    headerBg: bannerBg,
    contentBg: bannerBg,
    border: bannerBg,
    borderActive: primaryColor,
    borderNormal: lighten(0.05, bannerBg),
    footer: descText,
    footerHover: lighten(0.05, descText),
  },
  pagination: {
    activeNum: 'white',
    itemBg: darken(0.1, descText),
    itemBorderColor: darken(0.06, descText),
    disableText: descText,
    text: primaryColor,
    inactiveNum: primaryColor,
  },
  heatmap: {
    activityLow: darken(0.15, '#615D78'),
    activityHight: '#615D78',
    empty: '#342e3a',
    borderHover: primaryColor,
    monthLabel: descText,
    scale_1: lighten(0.04, '#342e3a'),
    scale_2: lighten(0.08, '#342e3a'),
    scale_3: lighten(0.12, '#342e3a'),
    scale_4: lighten(0.18, '#342e3a'),
    scale_5: lighten(0.3, '#342e3a'),
  },
  geoMap: {
    oceanColor: darken(0.03, '#3F3B4E'),
    regionBg: darken(0.1, '#615C78'),
    restRegionBg: '#2F2C3B',
    borderStroke: '#514960',
    markerBg: primaryMate,
    markerShadow: primaryMate,
  },
  bannerHeatmap: {
    activityLow: '#007D7C',
    activityHight: '#26A9A0',
    empty: '#342e3a',
    borderHover: primaryColor,
    monthLabel: descText,
    scale_1: lighten(0.04, '#342e3a'),
    scale_2: lighten(0.08, '#342e3a'),
    scale_3: lighten(0.12, '#342e3a'),
    scale_4: lighten(0.18, '#342e3a'),
    scale_5: lighten(0.3, '#342e3a'),
  },
  markdown: {
    title: '#6f728a',
    fg: markdownFont,
    titleBottom: '#49485a',
    hrColor: '#154452',
    blockquoteBorder: '0.25em solid #34535C',
    blockquoteFg: darken(0.09, markdownFont),
    strongFg: lighten(0.2, markdownFont),
    strongBg: '#34535C',
    link: '#9a591d',
    tableBg: lighten(0.01, contentBoxBg),
    tableBg2n: lighten(0.05, contentBoxBg),
    tableborder: `1px solid ${lighten(0.07, contentBoxBg)}`,
    taskDone: '#528416',
    taskPeding: lighten(0.1, contentBoxBg),
    br: '#49485a',
  },
  code: {
    bg: lighten(0.03, contentBoxBg),
  },
  shell: {
    link: lighten(0.2, contentBg),
    searchInput: lighten(0.1, contentBg),
    searchIcon: lighten(0.1, contentBg),
    barBg: darken(0.01, contentBg),
    border: lighten(0.05, contentBg),
    title: lighten(0.4, contentBg),
    desc: lighten(0.2, contentBg),
    activeBg: lighten(0.05, contentBg),
  },
  button: {
    primary: primaryColor,
    fg: lighten(0.4, primaryColor),
    hoverBg: lighten(0.1, primaryColor),
    activeBg: darken(0.01, primaryColor),
    clicked: primaryColor,
  },
  navigator: {
    activeBottom: primaryColor,
    borderRight: darken(0.05, bannerBg),
    hoverBg: lighten(0.05, bannerBg),
  },
  popover: {
    bg: bannerBg,
    borderColor: primaryColor,
    boxShadow: '0 1px 4px rgba(0, 0, 0, 0.15)',
  },
  tags: {
    dotOpacity: 0.5,
    text: '#72788D',
  },
  tagger: {
    text: '#959cb9',
    bg: '#4A4559',
    border: '#4A4559',
    closeBtn: '#959cb9',
  },
  tabs: {
    headerActive: primaryColor,
    header: darken(0.05, primaryColor),
    contentBg: lighten(0.05, contentBoxBg),
    headerBg: lighten(0.03, contentBoxBg),
    headerActiveTop: primaryColor,
    border: descText,
    bottomLine: descText,
  },
  modal: {
    bg: bannerBg,
    border: primaryColor,
    innerSelectBg: '#333040',
    subPanel: '#00313d',
    subPanelShadow: 'drop-shadow(3px 3px 6px #002a34)',
  },
  form: {
    inputBg: lighten(0.03, contentBoxBg),
    text: descText,
    label: primaryColor,
    border: descText,
    shadow: 'rgba(184, 198, 192, 0.3)',
  },
  a: {
    hover: primaryColor,
    active: darken(0.1, primaryColor),
  },
  toast: {
    bg: contentBoxBg,
    border: descText,
    message: descText,
    title: primaryColor,
    infoBar: primaryColor,
    errorBar: '#f59381',
    successBar: '#9dd035',
    warnBar: '#f5a30e',
  },
  mailBox: {
    headHightBg: bannerBg,
  },
  alertWarn: {
    border: '#ffe58f',
    bg: '#fffbe6',
    text: '#c3ae8e',
  },
  table: {
    headerBg: '#3c3644',
    headTitle: '#615C78',
    text: '#5E5C78',
    border: '#3c3644',
    hoverBg: '#383342',
  },
  searchHighlight: {
    doramonFg: 'orange',
    doramonBg: 'transparent',
  },
  tooltip: {
    text: '#B7B1C1',
    bg: '#56526E',
  },
  avatar: {
    opacity: 0.8,
    quote: '#217470',
    fallbackBg: '#074857',
    shadow: '0px 0px 4px 0px rgb(0 0 0 / 50%) inset',
    quoteShadow: '0px 0px 3px 0px rgb(0 0 0 / 30%) inset',
  },
}

export default purple
