## 介绍

本项目使用 [next-i18next](https://github.com/isaachinman/next-i18next) 实现多语种功能，例子参考[这里](https://github.com/isaachinman/next-i18next/tree/master/examples/simple)，该例子同时为 next.js 官方 example

## 使用

作为 hooks 使用:

```js
import { useTrans } from '@/hooks'

// ...
const { t } = useTrans()

// ...
<OptionItem>{t('my-favorite')}</OptionItem>

```

切换语言

```jsx
// ...
const { t, i18n } = useTrans(['home'])

// ...
<button
   type="button"
   onClick={() =>
     i18n.changeLanguage(i18n.language === 'en' ? 'zh' : 'en')
   }
 >
   toggle
</button>
```

## 注意事项

1. useTrans 如果不带参数的话默认是使用 i18n.js 中 `defaultNS` 对应的 nameSpace，即对应 `public/locales/xx/general.json`
2. useTrans 参数可以是 string 也可以是 array
3. 不同语言的包是按需加载的
4. 注意 i18n.js 中 `localeSubpaths` 对应的值，这里指的是 url 是否要按照对应语言添加前缀
