import styled from 'styled-components'

import { theme } from '@/utils/themes'
import css from '@/utils/css'

type TWrapper = { align: 'center' | 'right' }
export const Wrapper = styled.div<TWrapper>`
  ${css.flex('align-center')};
  width: 100%;
  justify-content: ${({ align }) =>
    align === 'center' ? 'center' : 'flex-end'};
`
export const CancelBtn = styled.div`
  opacity: 0.8;
  color: ${theme('button.primary')};
  font-size: 14px;

  &:hover {
    opacity: 1;
    cursor: pointer;
  }

  transition: opacity 0.2s;
`
