/*
 * a theme inspired by rethinkdb: https://rethinkdb.com/
 */

import { lighten, darken } from 'polished'

const primaryColor = '#5EABB3'

const bannerBg = '#DAE6E5'
const contentBg = '#E4EEED'
const contentBoxBg = '#f9fcfc'
const fontColor = primaryColor
const sidebarBg = '#1C4752'
const markdownFont = '#7698A0'

const descText = '#a3bbbd'
const primaryMate = 'orange'

const cyan = {
  _meta: {
    category: 'light',
  },
  name: 'cyan',
  logoText: descText,
  cover: primaryColor,
  coverIndex: '#F9FCFC',
  contrastFg: '#eca014',
  htmlBg: bannerBg,
  spaceBg: '#15363e',
  mobileTab: '#1D4751',
  loading: {
    basic: bannerBg,
    animate: lighten(0.03, bannerBg),
  },
  error: {
    title: primaryColor,
    desc: darken(0.1, primaryColor),
    bg: lighten(0.02, contentBoxBg),
  },

  font: fontColor,
  link: 'orange',
  main: '#7DC0C5',
  bodyBg: contentBg,
  selectionBg: '#f8f7dc',
  baseColor: {
    red: '#ca5f4d',
    orange: '#ad735c',
    yellow: '#B0BA6C',
    green: '#699411',
    cyan: '#24878C',
    blue: '#456fbd',
    purple: '#7d519e',

    grey: '#106d8a',
    pink: '#b36976',

    pinkLite: '#82606b',
    pinkBtnText: '#ded0d0',
  },
  header: {
    fg: primaryColor,
    bg: bannerBg,
    spliter: darken(0.04, bannerBg),
    fixed: contentBoxBg,
    tabActive: '#61868c', // articleTitle
    tabOthers: lighten(0.1, '#849ca0'),
    cardBg: '#e6ecec',
    cardBorder: '#ccd8d6',
    cardLogoText: '#A0BBBD',
    cardTitle: '#a0b5b9',
  },
  banner: {
    title: primaryColor,
    bg: bannerBg,
    desc: descText,
    spliter: bannerBg,
    numberDesc: '#a7bbbf',
    number: '#83a7ad',
    active: primaryMate,
    numberDivider: '#ccdcde',
    numberHoverBg: '#e4ecec',
  },
  thread: {
    bg: contentBoxBg,
    filterResultHint: descText,
    articleTitle: '#75979c',
    articleStrip: contentBoxBg,
    articleDigest: '#91b4b9',
    articleTag: '#71979a',
    articleLink: descText,
    articleDivider: '#dce5e6',
    commentsUserBorder: contentBoxBg,
    extraInfo: '#80b5b9',
    articleSpliter: '#dee8ea',
    // like github
    repoTitle: '#83a7ad',
  },
  content: {
    bg: contentBoxBg,
    border: contentBoxBg,
    cardBg: contentBoxBg,
    cardBorder: '#e6e6e6',
    cardBorderHover: primaryColor,
  },
  footer: {
    text: '#99afac',
    hover: '#5c868b',
    title: '#90acb1',
    bottomBg: '#d9e6e5',
  },
  sidebar: {
    bg: sidebarBg,
    activeBar: '#479fa9',
    holder: lighten(0.15, sidebarBg),
    logoText: '#5e9aa2',
    menuHover: darken(0.1, sidebarBg),
    pinActive: primaryColor,
    menuLink: '#D9E6E5',
    borderColor: '#14363E',
    headerShadow: '0px 6px 4px 0px rgba(0,0,0,0.2)',
    headerShadowBorderBottom: '1px dashed #316d7b',
    footerShadow: '-1px -4px 4px 0px rgba(0,0,0,0.2)',
    footerShadowBorderBottom: '1px dashed #316d7b',
    searchInputBottom: '#2b6775',
    searchInputBottomActive: '#61ABB2',
    searchInputHolder: '#3a7786',
  },
  drawer: {
    title: '#83a2a5',
    desc: '#83a2a5',
    font: primaryColor,
    bg: contentBg,
    shadow: '-5px 0px 14px 0px rgba(189,189,189,0.37)',
    closerShadow: '-3px 3px 5px 1px rgba(156,154,154,0.2)',
    markdownHelperBg: '#F9FCFC',
    accountBg: '#F9FCFC',
    articleBg: '#F9FCFC',
    helper: '#d9e5e6',
    helperHover: '#83a2a5',
    topLine: primaryColor,
    icon: 'tomato',
    divider: '#e0e6e5',
    /* single article page sidebar divider */
    sideDivider: '#b9d0cc',
  },
  article: {
    link: '#b5ccce',
    linkHover: 'orange',
    reactionTitle: '#7f979a',
    reactionHoverBg: '#f3f7f7',
  },
  comment: {
    bg: '#F9FCFC',
    icon: '#62868a',
    didIcon: 'orange',
    title: '#62868a',
    username: '#7FA7AC',
    number: '#efbc60',
    floor: '#91b4b9',
    reply: '#93b3b5',
    replyBg: '#e8f1f2',
    placeholder: '#C0D9DA',
    filter: '#62868a',
    filterActive: primaryColor,
    action: '#9eb7bb',
    // mention text displayed in article
    mentionText: '#91a4b5',
    mentionTextBg: '#fcffdb',
    // mention popover background
    mentionBg: '#F9FCFC',
    mentionBorder: primaryColor,
    mentionActiveBg: darken(0.1, '#F9FCFC'),
    mentionShadow: '0px 2px 10px 1px rgba(235, 235, 235, 1)',

    indentLine: '#035163',
    indentActive: '#4b6669',
  },
  editor: {
    title: '#7ea9ad',
    content: '#a6bebf',
    placeholder: '#B3CFD0',
    headerBg: '#F9FCFC',
    contentBg: '#F9FCFC',
    border: '#F9FCFC',
    borderActive: descText,
    borderNormal: '#e2eaea',
    footer: '#a6bebf',
    footerHover: darken(0.05, '#a6bebf'),
  },
  pagination: {
    activeNum: 'white',
    itemBg: '#cbe7ea',
    itemBorderColor: '#cbe7ea',
    disableText: '#BCD9DC',
    text: '#6d7f7b',
    inactiveNum: 'white',
  },

  heatmap: {
    activityLow: '#D6ECB2',
    activityHight: '#4F966E',
    borderHover: '#51abb2',
    empty: '#E4EEED',
    monthLabel: '#c6dbde',
    scale_1: '#bbd9da',
    scale_2: '#a0c7ca',
    scale_3: '#83bfc1',
    scale_4: '#5092A4',
    scale_5: '#427583',
  },
  geoMap: {
    oceanColor: '#F9FCFC',
    regionBg: '#A0BCBD',
    restRegionBg: '#D9E6E5',
    borderStroke: '#A0BBBD',
    markerBg: '#C2DEB6',
    markerShadow: '#C2DEB6',
  },
  bannerHeatmap: {
    activityLow: '#D6ECB2',
    activityHight: '#4F966E',
    borderHover: '#51abb2',
    empty: '#E4EEED',
    monthLabel: descText,
    scale_1: '#dbe290',
    scale_2: '#99c06f',
    scale_3: '#609d4c',
    scale_4: '#61793e',
    scale_5: '#37642c',
  },

  markdown: {
    title: primaryColor,
    fg: markdownFont,
    titleBottom: lighten(0.3, primaryColor),
    hrColor: '#154452',
    blockquoteBorder: '#b8d0ce',
    blockquoteFg: lighten(0.09, markdownFont),
    strongFg: '#7c999c',
    strongBg: contentBoxBg,
    link: '#c5ba78',
    tableBg: darken(0.01, contentBoxBg),
    tableBg2n: darken(0.05, contentBoxBg),
    tableborder: `1px solid ${darken(0.1, contentBoxBg)}`,
    taskDone: '#528416',
    taskPeding: darken(0.1, contentBoxBg),
    br: '#e8e8e8',
  },
  code: {
    bg: darken(0.05, contentBoxBg),
  },
  shell: {
    link: lighten(0.3, primaryColor),
    searchInput: lighten(0.3, primaryColor),
    searchIcon: lighten(0.3, primaryColor),
    barBg: darken(0.03, primaryColor),
    border: darken(0.05, primaryColor),
    title: '#d7eef1',
    desc: lighten(0.2, primaryColor),
    activeBg: darken(0.1, primaryColor),
  },
  button: {
    primary: primaryColor,
    fg: lighten(0.4, primaryColor),
    hoverBg: lighten(0.1, primaryColor),
    activeBg: darken(0.01, primaryColor),
    clicked: primaryColor,
  },
  navigator: {
    activeBottom: primaryColor,
    borderRight: darken(0.05, bannerBg),
    hoverBg: '#eee',
  },
  popover: {
    bg: '#f9fcfc',
    borderColor: '#51abb2',
    boxShadow: '0 1px 4px rgba(0, 0, 0, 0.15)',
  },
  tags: {
    dotOpacity: 0.4,
    text: '#83a7ad',
  },
  tagger: {
    text: '#d2a05f',
    bg: '#fff2b3',
    border: '#fff2b3',
    closeBtn: '#d2a05f',
  },
  tabs: {
    headerActive: primaryColor,
    header: lighten(0.08, primaryColor),
    contentBg: '#FFFFFF',
    headerBg: '#F7F9F9',
    headerActiveTop: primaryColor,
    border: '#E8E8E8',
    bottomLine: '#d9e9ea',
  },
  modal: {
    bg: contentBoxBg,
    border: primaryColor,
    innerSelectBg: '#e4eeed45',
    subPanel: '#00313d',
    subPanelShadow: 'drop-shadow(3px 3px 6px #002a34)',
  },
  form: {
    inputBg: '#FFFFFF',
    text: '#88a4ad',
    label: '#88a4ad',
    border: '#B8C6C0',
    shadow: 'rgba(184, 198, 192, 0.3)',
  },
  a: {
    hover: primaryColor,
    active: darken(0.1, primaryColor),
  },
  toast: {
    bg: contentBoxBg,
    border: descText,
    message: descText,
    title: primaryColor,
    infoBar: primaryColor,
    errorBar: '#f59381',
    successBar: '#9dd035',
    warnBar: '#f5a30e',
  },
  mailBox: {
    headHightBg: '#e8f9f8',
  },
  alertWarn: {
    border: '#ffe58f',
    bg: '#fffbe6',
    text: '#c3ae8e',
  },
  table: {
    headerBg: '#fff',
    headTitle: '#83a7ad',
    text: '#83a7ad',
    border: '#e8e8e8',
    hoverBg: '#fffef1',
  },
  searchHighlight: {
    doramonFg: '#F6DE38',
    doramonBg: 'transparent',
  },
  tooltip: {
    text: '#F8FBFC',
    bg: '#54A1AA',
  },
  avatar: {
    opacity: 1,
    quote: '#217470',
    fallbackBg: '#074857',
    shadow: '0px 0px 4px 0px rgb(0 0 0 / 50%) inset',
    quoteShadow: '0px 0px 3px 0px rgb(0 0 0 / 30%) inset',
  },
}

export default cyan
