import { memo, SVGProps } from 'react'

const SVG = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      className="icon"
      viewBox="0 0 1024 1024"
      xmlns="http://www.w3.org/2000/svg"
      width={200}
      height={200}
      {...props}
    >
      <path
        d="M173.056 947.712c0 41.984 73.728 76.288 164.352 76.288s164.352-34.304 164.352-76.288-73.728-76.288-164.352-76.288-164.352 33.792-164.352 76.288zm348.672 0c0 41.984 73.728 76.288 164.352 76.288 91.136 0 164.352-34.304 164.352-76.288s-73.728-76.288-164.352-76.288c-90.624-.512-164.352 33.792-164.352 76.288z"
        fill="#F5B824"
      />
      <path
        d="m878.08 506.88-36.864-118.784C840.704 1.536 528.384 0 512 0c-16.896 0-328.704 1.536-328.704 388.096L145.92 506.88S20.48 664.576 104.96 801.792c9.728 6.656 10.24 30.72 61.44-77.312 0 0 68.608 241.664 343.552 243.712h3.072c274.944-2.048 343.552-243.712 343.552-243.712 51.2 108.032 52.224 86.016 61.44 77.312C1003.52 664.576 878.08 506.88 878.08 506.88z"
        fill="#121213"
      />
      <path
        d="M526.336 254.464c0 51.712 29.696 93.696 66.56 93.696s66.56-41.984 66.56-93.696c0-51.712-29.696-93.696-66.56-93.696-36.864.512-66.56 41.984-66.56 93.696zm-171.008 0c0 51.712 29.696 93.696 66.56 93.696s66.56-41.984 66.56-93.696c0-51.712-29.696-93.696-66.56-93.696-36.352.512-66.56 41.984-66.56 93.696z"
        fill="#FFF"
      />
      <path
        d="M414.72 254.464c0 22.016 12.8 40.448 28.672 40.448s28.672-17.92 28.672-40.448-12.8-40.448-28.672-40.448c-15.872.512-28.672 18.432-28.672 40.448z"
        fill="#161616"
      />
      <path
        d="M781.312 466.944C668.16 561.152 512 550.4 512 550.4s-156.672 10.752-269.312-83.456c0 0-107.52 484.864 269.312 484.864s269.312-484.864 269.312-484.864z"
        fill="#FAFAFB"
      />
      <path
        d="M840.704 388.096S750.592 549.888 512 549.888 183.296 388.096 183.296 388.096c-38.4 103.936-37.376 118.784-37.376 118.784 36.864 40.96 80.896 74.752 129.536 99.84-3.072 34.816-7.68 88.064-7.168 115.2.512 42.496 26.624 45.056 86.528 51.2 59.904 5.632 47.616-10.24 47.616-37.376V650.24c63.488 12.288 109.056 7.68 109.056 7.68s208.896 21.504 366.08-152.064c.512 1.024 1.536-13.824-36.864-117.76z"
        fill="#D53118"
      />
      <path
        d="M687.616 407.552c-53.76-25.6-140.8-33.792-175.616-33.792s-121.856 8.192-175.616 33.792c-25.6 8.704-35.84 15.36-35.84 24.064 0 1.024 1.024 2.56 2.56 4.096 50.176 31.232 125.44 51.2 209.408 51.2s159.232-19.968 209.408-51.2c1.536-2.048 2.56-3.072 2.56-4.096-.512-8.704-10.752-15.36-36.864-24.064z"
        fill="#F0B225"
      />
    </svg>
  )
}

export default memo(SVG)
