/*
 * UserSettings store
 *
 */

import { types as T, getParent } from 'mobx-state-tree'

import { markStates } from '@/utils/mobx'

const UserSettings = T.model('UserSettings', {})
  .views((self) => ({
    get root() {
      return getParent(self)
    },
    get curTheme() {
      return self.root.theme.curTheme
    },
    get accountInfo() {
      return self.root.accountInfo
    },
    get isSelfViewing() {
      return self.root.viewing.isSelfViewing
    },
  }))
  .actions((self) => ({
    changeTheme(name) {
      self.root.changeTheme(name)
    },
    updateC11N(option) {
      self.root.updateC11N(option)
    },
    sponsorHepler() {
      self.root.sponsorHepler()
    },
    mark(sobj) {
      markStates(sobj, self)
    },
  }))

export default UserSettings
