# PKMDS: Pokémon Save Editor for Web

A web app to edit your Pokémon save files. Check it out at [pkmds.app](https://pkmds.app/)!

**The app should fully work while offline, after initially caching everything it needs.**

Powered by PKHeX.Core: https://github.com/kwsch/PKHeX

NOTE: for a list of supported save files / formats, [see the PKHeX README](https://github.com/codemonkey85/PKHeX?tab=readme-ov-file#readme).

Sprites from: https://github.com/msikma/pokesprite-spritesheet

Some images from: https://github.com/msikma/PokeDings

[![Build and Test](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/buildandtest.yml/badge.svg)](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/buildandtest.yml)

[![Deploy to GitHub Pages](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/main.yml/badge.svg)](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/main.yml)

[![pages-build-deployment](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/pages/pages-build-deployment/badge.svg)](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/pages/pages-build-deployment)

[![Dependabot Updates](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/dependabot/dependabot-updates/badge.svg)](https://github.com/codemonkey85/PKMDS-Blazor/actions/workflows/dependabot/dependabot-updates)

Special thanks to [Kaphotics](https://github.com/kwsch/), as well as [all the contributors to PKHeX and PKHeX.Core](https://github.com/kwsch/PKHeX/graphs/contributors).

PLEASE NOTE: PKMDS does not, and will never, support custom ROMs.

<details>
  <summary>FAQ</summary>

Q: What is PKMDS?

A: PKMDS is a web app that allows you to edit your Pokémon save files. It is powered by PKHeX.Core, which is a .NET Core library that can read and write Pokémon save files.

Q: What is PKHeX?

A: PKHeX is a Windows application that allows you to edit your Pokémon save files. PKMDS is a web app that is powered by PKHeX.Core, which is a .NET Core library that can read and write Pokémon save files.

Q: What is PKHeX.Core?

A: PKHeX.Core is a .NET Core library that can read and write Pokémon save files. It is used by PKMDS to read and write Pokémon save files.

Q: What is a Pokémon save file?

A: A Pokémon save file is a file that contains the data for a Pokémon game. It contains information about the player's progress in the game, as well as the Pokémon that the player has caught.

Q: What games are supported by PKMDS?

A: PKMDS currently supports the following games:
- Pokémon Scarlet and Violet
- Pokémon Legends: Arceus
- Pokémon Brilliant Diamond and Shining Pearl
- Pokémon Sword and Shield
- Pokémon Let's Go Pikachu and Eevee
- Pokémon Ultra Sun and Ultra Moon
- Pokémon Sun and Moon
- Pokémon Omega Ruby and Alpha Sapphire
- Pokémon X and Y
- Pokémon Black 2 and White 2
- Pokémon Black and White
- Pokémon HeartGold and SoulSilver
- Pokémon Platinum
- Pokémon Diamond and Pearl
- Pokémon XD: Gale of Darkness
- Pokémon Emerald
- Pokémon FireRed and LeafGreen
- Pokémon Box: Ruby and Sapphire
- Pokémon Colosseum
- Pokémon Ruby and Sapphire
- Pokémon Crystal
- Pokémon Stadium 2
- Pokémon Gold and Silver
- Pokémon Stadium
- Pokémon Yellow
- Pokémon Red and Blue
- Pokémon Green

Q: How do I use PKMDS?

A: To use PKMDS, simply upload your Pokémon save file to the web app. You can then edit the save file using the web app's interface. Once you are done editing the save file, you can download the modified save file and use it with your game.

Q: Is PKMDS free to use?

A: Yes, PKMDS is free to use. You can use it to edit your Pokémon save files without any cost.

Q: Can I trust PKMDS with my save files?

A: PKMDS is an open-source project, which means that you can inspect the source code to see how it works. The source code for PKMDS is available on GitHub, so you can see exactly what the web app is doing with your save files.

Q: Can I contribute to PKMDS?

A: Yes, you can contribute to PKMDS by submitting bug reports, feature requests, or code changes. The source code for PKMDS is available on GitHub, so you can fork the repository and make changes to the code.

Q: Who created PKMDS?

A: PKMDS was created by codemonkey85, who is a software developer with a passion for Pokémon games. The web app is powered by PKHeX.Core, which is a .NET Core library that can read and write Pokémon save files. PKHeX.Core was created and is maintained by Kaphotics. The sprites used in PKMDS are from the pokesprite-spritesheet repository, which is maintained by msikma.

Q: How can I contact the creator of PKMDS?

A: You can contact the creator of PKMDS by sending an email to [michael@bondcodes.com](mailto:michael@bondcodes.com?subject=PKMDS%20for%20Web). You can also reach out to the creator on GitHub by opening an issue on the PKMDS repository.

Q: How can I support PKMDS?

A: You can support PKMDS by starring the project on GitHub, sharing it with your friends, or contributing to the project by submitting bug reports, feature requests, or code changes.

Q: What are the system requirements for PKMDS?

A: PKMDS is a web app, so it can be used on any device that has a web browser. You can use PKMDS on a desktop computer, laptop, tablet, or smartphone. Please note that the app runs best in Google Chrome or Chromium-based browsers - I've noticed some UI bugs in Safari for instance.

Q: Can I use PKMDS on my mobile device?

A: Yes, you can use PKMDS on your mobile device. The web app is designed to be responsive, so it will work on any device that has a web browser.

Q: Can I use PKMDS on my Nintendo Switch?

A: No, you cannot use PKMDS on your Nintendo Switch. The web app is designed to be used on devices that have a web browser, such as a desktop computer, laptop, tablet, or smartphone.

Q: Can I use PKMDS on my Mac?

A: Yes, you can use PKMDS on your Mac. The web app is designed to be used on any device that has a web browser, including Mac computers.

</details>

## Star History

<a href="https://star-history.com/#codemonkey85/PKMDS-Blazor&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=codemonkey85/PKMDS-Blazor&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=codemonkey85/PKMDS-Blazor&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=codemonkey85/PKMDS-Blazor&type=Date" />
 </picture>
</a>
