# Puppertino's Guide on Contributions.
As Puppertino grows, and contributors join, we must help them know what is the best way of helping Puppertino to grow, to have a cohesive and correct framework that allows people to create amazing things, and make our best effort to avoid Puppertino to collide on itself or have any type of errors.

That said, welcome to Puppertino's Guide for Contributions, we hope that this documentation helps you have a better understanding of how to add your amazing changes to Puppertino.

Keep in mind: This document may change in the future based on situations, or new additions that we feel are necessary to add to the Puppertino's Guide on Contributions. So please keep an eye out for any possible changes.

## General Guidelines
Changes for Puppertino are important. But there are several guidelines that you need to keep in mind. These are the bases and cornerstones in which Puppertino is built and needs to be kept, so keep them in mind when creating a new contribution.

### All changes must provide value.
Every change that you make, has to be **well documented, well thought out and well defined**. Changes are meant to add better functionalities, be more performant, reliable, or better looking than what Puppertino currently has.

Changes that don't provide value and just *add, edit or delete* for the sake of it without adding nothing to the framework **will not be accepted**. 

 ### Test your code before submitting a PR.
Puppertino is a framework. This means that you won't have control of what people do with it, so testing always comes in handy to debug and see how your code performs and is used in several environments.

### Very slim changes will not be accepted
Changing just a value, fixing a typo, or changes so simples that don't add anything to the stability, functionality, aesthetic of Puppertino will not be accepted. It is preferred to add an Issue.

### Don't submit incomplete features
Incomplete features will not be accepted into Puppertino's main repo. You may open an issue on the main repo asking people to help with your fork. But you may not submit incomplete features or WIP to the main repo.

### Be descriptive on your PR.
When submitting a new PR, please describe the additions, deletions, or any type of change made on Puppertino. Explain if this fixes a problem (And how it does it), how does it work or what does it add to Puppertino. The more descriptive you can be, the better. This way we can analyze the changes you have made more carefully and have a better understanding of what you have done, rather than just have a bunch of code changed without we knowing what exactly it does or how does it help Puppertino.

### Maintain visual consistency when creating or editing elements.
Puppertino is inspired by [Human Guidelines](https://developer.apple.com/design/human-interface-guidelines/). This means that every change you make must be based on Human Guidelines. We will never ask for the elements to be the same. We just need to keep a visual consistency through all of our elements, so we don't disrupt the experience of the end-users or developers.