## Why is this an issue?

Parameters are part of the [method signature](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/methods#method-signatures) and its
identity.

Implementing a method from an interface, a base class, or a partial method and changing one of its parameters' names will confuse and impact the
method’s readability.

    interface IBankAccount
    {
      void AddMoney(int money);
    }
    
    class BankAccount : IBankAccount
    {
      void AddMoney(int amount) // Noncompliant: parameter's name differs from base
      {
        // ...
      }
    }

To avoid any ambiguity in the code, a parameter’s name should match the initial declaration, whether its initial declaration is from an interface,
a base class, or a partial method.

    interface IBankAccount
    {
      void AddMoney(int money);
    }
    
    class BankAccount : IBankAccount
    {
      void AddMoney(int money) // Compliant: parameter's name match base name
      {
        // ...
      }
    }

## Resources

### Documentation

- [Method signatures in
  C#](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/methods#method-signatures)
- [Method signatures - Wiki](https://en.wikipedia.org/wiki/Type_signature#Method_signature)