## Why is this an issue?

The use of increment and decrement operators in method calls or in combination with other arithmetic operators is not recommended, because:

- It can significantly impair the readability of the code.
- It introduces additional side effects into a statement, with the potential for undefined behavior.
- It is safer to use these operators in isolation from any other arithmetic operators.

### Noncompliant code example

    u8a = ++u8b + u8c--;
    foo = bar++ / 4;

### Compliant solution

The following sequence is clearer and therefore safer:

    ++u8b;
    u8a = u8b + u8c;
    u8c--;
    foo = bar / 4;
    bar++;