**This rule is deprecated, and will eventually be removed.**

Component parameters can only receive query parameter values in routable components with an @page directive.

## Why is this an issue?

[SupplyParameterFromQuery](https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.components.supplyparameterfromqueryattribute)
attribute is used to specify that a component parameter of a routable component comes from the [query string](https://en.wikipedia.org/wiki/Query_string).

In the case of non-routable components, the `SupplyParameterFromQuery` does not contribute to the functionality, and removing it will
not affect the behavior.

## How to fix it

Either make the component routable or remove the `SupplyParameterFromQuery` attribute.

### Code examples

#### Noncompliant code example

    <h3>Component</h3>
    
    @code {
        [Parameter]
        [SupplyParameterFromQuery]  // Noncompliant
        public bool Param { get; set; }
    }

#### Compliant solution

    @page "/component"
    
    <h3>Component</h3>
    
    @code {
        [Parameter]
        [SupplyParameterFromQuery]  // Compliant
        public bool Param { get; set; }
    }

## Resources

### Documentation

- Microsoft Learn - [Query strings](https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/routing#query-strings)
- Microsoft Learn - [SupplyParameterFromQueryAttribute Class](https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.components.supplyparameterfromqueryattribute)
- Wikipedia - [query string](https://en.wikipedia.org/wiki/Query_string)