## Why is this an issue?

In Blazor, when a [route parameter
constraint](https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/routing#route-constraints) is applied, the value is automatically cast to the corresponding component parameter type. If the constraint type does not match the
component parameter type, it can lead to confusion and potential runtime errors due to unsuccessful casting. Therefore, it is crucial to ensure that
the types of route parameters and component parameters match to prevent such issues and maintain code clarity.

## How to fix it

Ensure the component parameter type matches the route parameter constraint type.

| Constraint Type | .NET Type |
| --- | --- |
| bool | bool |
| datetime | DateTime |
| decimal | decimal |
| double | double |
| float | float |
| guid | Guid |
| int | int |
| long | long |
| string | string |

### Code examples

#### Noncompliant code example

    @page "/my-route/{Param:datetime}"
    
    @code {
        [Parameter]
        public string Param { get; set; } // Noncompliant
    }

#### Compliant solution

    @page "/my-route/{Param:datetime}"
    
    @code {
        [Parameter]
        public DateTime Param { get; set; } // Compliant
    }

## Resources

### Documentation

- Microsoft Learn - [Blazor routing and
  navigation - Route Constraints](https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/routing#route-constraints)