## Why is this an issue?

In Blazor, the [\[JSInvokable\]](https://learn.microsoft.com/en-us/dotnet/api/microsoft.jsinterop.jsinvokableattribute) attribute is used
to annotate a method, enabling it to be invoked from JavaScript code. The prerequisite for this functionality is that the method must be declared as
`public`.  
 Otherwise, a runtime error will be triggered when an attempt is made to call the method from JavaScript.

## How to fix it

To fix the issue, ensure the methods annotated with the `[JSInvokable]` attribute are `public.`

### Code examples

#### Noncompliant code example

    @code {
        [JSInvokable]
        private static void MyStaticMethod() { } // Noncompliant
    
        [JSInvokable]
        internal void MyMethod() { } // Noncompliant
    }

#### Compliant solution

    @code {
        [JSInvokable]
        public static void MyStaticMethod() { } // Compliant
    
        [JSInvokable]
        public void MyMethod() { } // Compliant
    }

## Resources

### Documentation

- Microsoft Learn - [Call
  .NET methods from JavaScript functions in ASP.NET Core Blazor](https://learn.microsoft.com/en-us/aspnet/core/blazor/javascript-interoperability/call-dotnet-from-javascript)
- Microsoft Learn - [JSInvokableAttribute
  Class](https://learn.microsoft.com/en-us/dotnet/api/microsoft.jsinterop.jsinvokableattribute)