## Why is this an issue?

The [SupplyParameterFromQuery](https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.components.supplyparameterfromqueryattribute)
attribute can be used to specify that a component parameter, of a routable component, comes from the query string.

Component parameters supplied from the query string support the following types:

- bool, DateTime, decimal, double, float, Guid, int, long, string.
- Nullable variants of the preceding types.
- Arrays of the preceding types, whether they’re nullable or not nullable.

Query parameters should have one of the supported types. Otherwise, an unhandled exception will be raised at runtime.

    Unhandled exception rendering component: Querystring values cannot be parsed as type '<type>'.
    System.NotSupportedException: Querystring values cannot be parsed as type '<type>'
    ...

## How to fix it

Change the parameter type to one of the following ones:

- bool, DateTime, decimal, double, float, Guid, int, long, string.
- Nullable variants of the preceding types.
- Arrays of the preceding types, whether they’re nullable or not nullable.

### Code examples

#### Noncompliant code example

    @page "/print"
    <p> Parameter value is: @Value </p>
    @code {
        [Parameter]
        [SupplyParameterFromQuery()]
        public TimeSpan Value { get; set; }     // Noncompliant
    }

#### Compliant solution

    @page "/print"
    <p> Parameter value is: @Value </p>
    @code {
        [Parameter]
        [SupplyParameterFromQuery()]
        public long Value { get; set; }         // Compliant
    }

## Resources

### Documentation

- Microsoft Learn - [SupplyParameterFromQueryAttribute](https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.components.supplyparameterfromqueryattribute)