Within a [message template](https://messagetemplates.org/) each named placeholder should be in PascalCase.

## Why is this an issue?

Using consistent naming conventions is important for the readability and maintainability of code. In the case of message templates, using
PascalCase for named placeholders ensures consistency with structured logging conventions, where each named placeholder is used as a property name in
the structured data.

The rule covers the following logging frameworks:

- Nuget package - [Microsoft.Extensions.Logging](https://www.nuget.org/packages/Microsoft.Extensions.Logging)
- Nuget package - [Serilog](https://www.nuget.org/packages/Serilog)
- Nuget package - [Nlog](https://www.nuget.org/packages/NLog)

## How to fix it

Use PascalCase for named placeholders.

### Code examples

#### Noncompliant code example

    logger.LogDebug("User {firstName} logged in", firstName); // Noncompliant

#### Compliant solution

    logger.LogDebug("User {FirstName} logged in", firstName); // Compliant

## Resources

### Documentation

- Microsoft Learn - [CA1727: Use PascalCase for
  named placeholders](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1727)
- Serilog Analyzer - [Serilog006: Pascal Cased Property
  Verifier](https://github.com/Suchiman/SerilogAnalyzer/blob/master/README.md#serilog006-pascal-cased-property-verifier)