## Why is this an issue?

Sharing some naming conventions is a key point to make it possible for a team to efficiently collaborate. This rule checks that the logger field or
property name matches a provided regular expression.

The rule supports the most popular logging frameworks:

- Nuget package - [Microsoft.Extensions.Logging](https://www.nuget.org/packages/Microsoft.Extensions.Logging)
- Nuget package - [Serilog](https://www.nuget.org/packages/Serilog)
- Nuget package - [Castle.Core](https://www.nuget.org/packages/Castle.Core)
- Nuget package - [NLog](https://www.nuget.org/packages/NLog)
- Nuget package - [log4net](https://www.nuget.org/packages/log4net)

## How to fix it

Update the name of the field or property to follow the configured naming convention. By default, the following names are considered compliant:

- `{logger}`
- `{_logger}`
- `{Logger}`
- `{_Logger}`
- `{log}`
- `{_log}`

### Noncompliant code example

    private readonly ILogger myLogger; // Noncompliant
    
    public ILogger MyLogger { get; set; } // Noncompliant

### Compliant solution

    private readonly ILogger logger; // Compliant
    
    public ILogger Logger { get; set; } // Compliant

## Resources

### Documentation

- Microsoft Learn - [Coding conventions](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/coding-style/coding-conventions)