## Why is this an issue?

Most logging frameworks have methods that take a log level, an event ID or an exception as a separate input next to the log format and its
arguments. There is a high chance that if the log level, the event ID or the exception are passed as the arguments to the message format, it was a
mistake. This rule is going to raise in that scenario.

The rule covers the following logging frameworks:

- Nuget package - [Castle.Core](https://www.nuget.org/packages/Castle.Core)
- Nuget package - [Serilog](https://www.nuget.org/packages/Serilog)
- Nuget package - [NLog](https://www.nuget.org/packages/NLog)
- Nuget package - [Microsoft.Extensions.Logging](https://www.nuget.org/packages/Microsoft.Extensions.Logging)

## How to fix it

Use the dedicated overload that takes the log level, event id, and/or exception as arguments.

### Noncompliant code example

    try { }
    catch (Exception ex)
    {
        logger.LogDebug("An exception occured {Exception} with {EventId}.", ex, eventId); // Noncompliant
    }

### Compliant solution

    try { }
    catch (Exception ex)
    {
        logger.LogDebug(eventId, ex, "An exception occured.");
    }

### Exceptions

This rule will not raise an issue if one of the parameters mentioned above is passed twice, once as a separate argument to the invocation and once
as an argument to the message format.

    try { }
    catch (Exception ex)
    {
        logger.LogDebug(ex, "An exception occured {Exception}.", ex); // Compliant
    }

## Resources

### Documentation

- Microsoft Learn - [LoggerExtensions
  Class](https://learn.microsoft.com/en-us/dotnet/api/microsoft.extensions.logging.loggerextensions)