## Why is this an issue?

With .NET Core the `UnixEpoch` field was introduced to `DateTime` and `DateTimeOffset` types. Using this field
clearly states that the intention is to use the beginning of the Unix epoch.

### What is the potential impact?

You should not use the `DateTime` or `DateTimeOffset` constructors to set the time to the 1st of January 1970 to represent
the beginning of the Unix epoch. Not everyone is familiar with what this particular date is representing and it can be misleading.

## How to fix it

To fix this issue, use the `UnixEpoch` field of `DateTime` or `DateTimeOffset` instead of the constructor.

### Code examples

#### Noncompliant code example

    void GetEpochTime()
    {
        var epochTime = new DateTime(1970, 1, 1);
    }

#### Compliant solution

    void GetEpochTime()
    {
        var epochTime = DateTime.UnixEpoch;
    }

## Resources

### Documentation

- [DateTime.UnixEpoch documentation](https://learn.microsoft.com/en-us/dotnet/api/system.datetime.unixepoch)
- [DateTimeOffset.UnixEpoch documentation](https://learn.microsoft.com/en-us/dotnet/api/system.datetimeoffset.unixepoch)
- [Unix time](https://en.wikipedia.org/wiki/Unix_time)