## Why is this an issue?

The [ExcludeFromCodeCoverageAttribute](https://learn.microsoft.com/dotnet/api/system.diagnostics.codeanalysis.excludefromcodecoverageattribute) is
used to exclude portions of code from [code coverage
reporting](https://learn.microsoft.com/dotnet/core/testing/unit-testing-code-coverage). It is a bad practice to retain code that is not covered by unit tests. In .Net 5, the `Justification` property was added to
the `ExcludeFromCodeCoverageAttribute` as an opportunity to document the rationale for the exclusion. This rule raises an issue when no
such justification is given.

### Noncompliant code example

    public struct Coordinates
    {
        public int X { get; }
        public int Y { get; }
    
        [ExcludeFromCodeCoverage] // Noncompliant
        public override bool Equals(object obj) => obj is Coordinates coordinates && X == coordinates.X && Y == coordinates.Y;
    
        [ExcludeFromCodeCoverage] // Noncompliant
        public override int GetHashCode()
        {
            var hashCode = 1861411795;
            hashCode = hashCode * -1521134295 + X.GetHashCode();
            hashCode = hashCode * -1521134295 + Y.GetHashCode();
            return hashCode;
        }
    }

### Compliant solution

    public struct Coordinates
    {
        public int X { get; }
        public int Y { get; }
    
        [ExcludeFromCodeCoverage(Justification = "Code generated by Visual Studio refactoring")] // Compliant
        public override bool Equals(object obj) => obj is Coordinates coordinates && X == coordinates.X && Y == coordinates.Y;
    
        [ExcludeFromCodeCoverage(Justification = "Code generated by Visual Studio refactoring")] // Compliant
        public override int GetHashCode()
        {
            var hashCode = 1861411795;
            hashCode = hashCode * -1521134295 + X.GetHashCode();
            hashCode = hashCode * -1521134295 + Y.GetHashCode();
            return hashCode;
        }
    }

## Resources

- [API browser](https://learn.microsoft.com/dotnet/api/system.diagnostics.codeanalysis.excludefromcodecoverageattribute) -
  ExcludeFromCodeCoverageAttribute
- [DevOps and testing](https://learn.microsoft.com/dotnet/core/testing/unit-testing-code-coverage) - Code coverage reporting