## Why is this an issue?

Locking on a local variable can undermine synchronization because two different threads running the same method in parallel will potentially lock
on different instances of the same object, allowing them to access the synchronized block at the same time.

### Noncompliant code example

    private void DoSomething()
    {
      object local = new object();
      // Code potentially modifying the local variable ...
    
      lock (local) // Noncompliant
      {
        // ...
      }
    }

### Compliant solution

    private readonly object lockObj = new object();
    
    private void DoSomething()
    {
      lock (lockObj)
      {
        //...
      }
    }

## Resources

- [Lock Statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/lock) - lock statement - ensure
  exclusive access to a shared resource
- CWE - [CWE-412 - Unrestricted Externally Accessible Lock](https://cwe.mitre.org/data/definitions/412)
- CWE - [CWE-413 - Improper Resource Locking](https://cwe.mitre.org/data/definitions/413)