## Why is this an issue?

Capturing and logging errors is critical to monitoring the health of your Azure Functions application.

Each `catch` block inside an Azure Function should log helpful details about the failure. Moreover, the logging should not be done at
`Debug` or `Trace` level.

Consider using the built-in integration with Application Insights for better monitoring of your Application.

### Noncompliant code example

    [FunctionName("Foo")]
    public static async Task<IActionResult> Run([HttpTrigger(AuthorizationLevel.Anonymous, "get", "post", Route = null)] HttpRequest req,ILogger log)
    {try{	// do stuff that can fail}catch (Exception ex){	// the failure is not logged at all OR is logged at DEBUG/TRACE level}
    }

### Compliant solution

    [FunctionName("Foo")]
    public static async Task<IActionResult> Run([HttpTrigger(AuthorizationLevel.Anonymous, "get", "post", Route = null)] HttpRequest req,ILogger log)
    {try{	// do stuff that can fail}catch (Exception ex){	log.LogError(ex, "Give details that will help investigations");}
    }

## Resources

- [Azure Functions error handling and
  retries](https://docs.microsoft.com/en-us/azure/azure-functions/functions-bindings-error-pages?tabs=csharp)
- [Monitor Azure Functions](https://docs.microsoft.com/en-us/azure/azure-functions/functions-monitoring)
- [Application Insights for Azure Functions
  supported features](https://docs.microsoft.com/en-us/azure/azure-monitor/app/azure-functions-supported-features)
- STIG Viewer - [Application Security and
  Development: V-222610](https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222610) - The application must generate error messages that provide information necessary for corrective actions without revealing
  information that could be exploited by adversaries.