## Why is this an issue?

The top-most level of an Azure Function code should include a try/catch block to capture and log all errors so you can monitor the health of the
application effectively. In case a retry policy has been defined for your Azure Function, you should rethrow any errors that should result in a
retry.

### Noncompliant code example

    [FunctionName("HttpExample")]
    public static async Task<IActionResult> Run(
        [HttpTrigger(AuthorizationLevel.Function, "get", "post", Route = null)] HttpRequest req)
    {
        // Noncompliant
        string requestBody = await new StreamReader(req.Body).ReadToEndAsync();
        dynamic data = JsonConvert.DeserializeObject(requestBody);
        // do stuff
    }

### Compliant solution

    [FunctionName("HttpExample")]
    public static async Task<IActionResult> Run(
        [HttpTrigger(AuthorizationLevel.Function, "get", "post", Route = null)] HttpRequest req)
    {
        try
        {
            string requestBody = await new StreamReader(req.Body).ReadToEndAsync();
            dynamic data = JsonConvert.DeserializeObject(requestBody);
            // do stuff
        }
        catch (Exception ex)
        {
            // do stuff
        }
    }

## Resources

- [Azure Functions error handling and
  retries](https://docs.microsoft.com/en-us/azure/azure-functions/functions-bindings-error-pages?tabs=csharp)
- [Azure
  Functions retry policies](https://docs.microsoft.com/en-us/azure/azure-functions/functions-bindings-error-pages?tabs=csharp#retry-policies-preview)