ASP.NET 1.1+ comes with a feature called *Request Validation*, preventing the server to accept content containing un-encoded HTML. This
feature comes as a first protection layer against Cross-Site Scripting (XSS) attacks and act as a simple Web Application Firewall (WAF) rejecting
requests potentially containing malicious content.

While this feature is not a silver bullet to prevent all XSS attacks, it helps to catch basic ones. It will for example prevent `<script
type="text/javascript" src="https://malicious.domain/payload.js">` to reach your Controller.

Note: *Request Validation* feature being only available for ASP.NET, no Security Hotspot is raised on ASP.NET Core applications.

## Ask Yourself Whether

- the developer doesn’t know the impact to deactivate the Request Validation feature
- the web application accepts user-supplied data
- all user-supplied data are not validated

There is a risk if you answered yes to any of those questions.

## Recommended Secure Coding Practices

- Activate the Request Validation feature for all HTTP requests

## Sensitive Code Example

At Controller level:

    [ValidateInput(false)]
    public ActionResult Welcome(string name)
    {
      ...
    }

At application level, configured in the Web.config file:

    <configuration>
       <system.web>
          <pages validateRequest="false" />
          ...
          <httpRuntime requestValidationMode="0.0" />
       </system.web>
    </configuration>

## Compliant Solution

At Controller level:

    [ValidateInput(true)]
    public ActionResult Welcome(string name)
    {
      ...
    }

or

    public ActionResult Welcome(string name)
    {
      ...
    }

At application level, configured in the Web.config file:

    <configuration>
       <system.web>
          <pages validateRequest="true" />
          ...
          <httpRuntime requestValidationMode="4.5" />
       </system.web>
    </configuration>

## See

- OWASP - [Top 10 2021 Category A3 - Injection](https://owasp.org/Top10/A03_2021-Injection/)
- [HttpRuntimeSection.RequestValidationMode Property](https://docs.microsoft.com/en-us/dotnet/api/system.web.configuration.httpruntimesection.requestvalidationmode?view=netframework-4.8)
- [OWASP ASP.NET Request Validation](https://owasp.org/www-community/ASP-NET_Request_Validation)
- [OWASP Cheat Sheet](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) - XSS
  Prevention Cheat Sheet
- OWASP - [Top 10 2017 Category A7 - Cross-Site Scripting
  (XSS)](https://owasp.org/www-project-top-ten/2017/A7_2017-Cross-Site_Scripting_%28XSS%29)
- CWE - [CWE-79 - Improper Neutralization of Input During Web Page Generation ('Cross-site
  Scripting')](https://cwe.mitre.org/data/definitions/79)