Using sockets is security-sensitive. It has led in the past to the following vulnerabilities:
 
-	    [CVE-2011-178](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2011-1785)
-	    [CVE-2017-5645](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5645)
-	    [CVE-2018-6597](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-6597)

Sockets are vulnerable in multiple ways:

-	    They enable a software to interact with the outside world. As this world is full of attackers it is necessary to check that they cannot receive
  sensitive information or inject dangerous input.
-	    The number of sockets is limited and can be exhausted. Which makes the application unresponsive to users who need additional sockets.

This rules flags code that creates sockets. It matches only the direct use of sockets, not use through frameworks or high-level APIs such as the use of http connections.
 
## Ask Yourself Whether

-	    sockets are created without any limit every time a user performs an action.
-	    input received from sockets is used without being sanitized.
-	    sensitive data is sent via sockets without being encrypted.

There is a risk if you answered yes to any of those questions.
 
## Recommended Secure Coding Practices

-	    In many cases there is no need to open a socket yourself. Use instead libraries and existing protocols.
-	    Encrypt all data sent if it is sensitive. Usually it is better to encrypt it even if the data is not sensitive as it might change later.
-	    [Sanitize](https://www.owasp.org/index.php/Input_Validation_Cheat_Sheet) any input read from the socket.
-	    Limit the number of sockets a given user can create. Close the sockets as soon as possible.

## Sensitive Code Example

    using System.Net.Sockets;
    
    class TestSocket
    {
        public static void Run()
        {
            // Sensitive
            Socket socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
    
            // TcpClient and UdpClient simply abstract the details of creating a Socket
            TcpClient client = new TcpClient("example.com", 80); // Sensitive
            UdpClient listener = new UdpClient(80); // Sensitive
        }
    }

## See

-	    [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure
-	    [MITRE, CWE-20](https://cwe.mitre.org/data/definitions/20) - Improper Input Validation
-	    [MITRE, CWE-400](https://cwe.mitre.org/data/definitions/400) - Uncontrolled Resource Consumption ('Resource Exhaustion')
-	    [MITRE, CWE-200](https://cwe.mitre.org/data/definitions/200) - Exposure of Sensitive Information to an Unauthorized Actor
-	    [SANS Top 25](https://www.sans.org/top25-software-errors/#cat2) - Risky Resource Management
-	    [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

## Deprecated
 
This rule is deprecated, and will eventually be removed.