Cryptographic hash algorithms such as `MD2`, `MD4`, `MD5`, `MD6`, `HAVAL-128`,
`HMAC-MD5`, `DSA` (which uses `SHA-1`), `RIPEMD`, `RIPEMD-128`, `RIPEMD-160`,
`HMACRIPEMD160` and `SHA-1` are no longer considered secure, because it is possible to have `collisions` (little
computational effort is enough to find two or more different inputs that produce the same hash).

## Ask Yourself Whether

The hashed value is used in a security context like:

- User-password storage.
- Security token generation (used to confirm e-mail when registering on a website, reset password, etc …​).
- To compute some message integrity.

There is a risk if you answered yes to any of those questions.

## Recommended Secure Coding Practices

Safer alternatives, such as `SHA-256`, `SHA-512`, `SHA-3` are recommended, and for password hashing, it’s even
better to use algorithms that do not compute too "quickly", like `bcrypt`, `scrypt`, `argon2` or `pbkdf2`
because it slows down `brute force attacks`.

## Sensitive Code Example

    var hashProvider1 = new MD5CryptoServiceProvider(); // Sensitive
    var hashProvider2 = (HashAlgorithm)CryptoConfig.CreateFromName("MD5"); // Sensitive
    var hashProvider3 = new SHA1Managed(); // Sensitive
    var hashProvider4 = HashAlgorithm.Create("SHA1"); // Sensitive

## Compliant Solution

    var hashProvider1 = new SHA512Managed(); // Compliant
    var hashProvider2 = (HashAlgorithm)CryptoConfig.CreateFromName("SHA512Managed"); // Compliant
    var hashProvider3 = HashAlgorithm.Create("SHA512Managed"); // Compliant

## See

- OWASP - [Top 10 2021 Category A2 - Cryptographic Failures](https://owasp.org/Top10/A02_2021-Cryptographic_Failures/)
- OWASP - [Top 10 2017 Category A3 - Sensitive Data
  Exposure](https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure)
- OWASP - [Top 10 2017 Category A6 - Security
  Misconfiguration](https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration)
- OWASP - [Mobile AppSec Verification Standard - Cryptography Requirements](https://mas.owasp.org/checklists/MASVS-CRYPTO/)
- OWASP - [Mobile Top 10 2016 Category M5 -
  Insufficient Cryptography](https://owasp.org/www-project-mobile-top-10/2016-risks/m5-insufficient-cryptography)
- CWE - [CWE-1240 - Use of a Risky Cryptographic Primitive](https://cwe.mitre.org/data/definitions/1240)