## Why is this an issue?

When the syntax `new Guid()` (i.e. parameterless instantiation) is used, it must be that one of three things is wanted:

1. An empty GUID, in which case `Guid.Empty` is clearer.
2. A randomly-generated GUID, in which case `Guid.NewGuid()` should be used.
3. A new GUID with a specific initialization, in which case the initialization parameter is missing.

This rule raises an issue when a parameterless instantiation of the `Guid` struct is found.

### Noncompliant code example

    public void Foo()
    {
        var g1 = new Guid();    // Noncompliant - what's the intent?
        Guid g2 = new();        // Noncompliant
        var g3 = default(Guid); // Noncompliant
        Guid g4 = default;      // Noncompliant
    }

### Compliant solution

    public void Foo(byte[] bytes)
    {
        var g1 = Guid.Empty;
        var g2 = Guid.NewGuid();
        var g3 = new Guid(bytes);
    }