## Why is this an issue?

Private fields which are written but never read are a case of "dead store". Changing the value of such a field is useless and most probably
indicates an error in the code.

    public class Rectangle
    {
      private readonly int length;
      private readonly int width;  // Noncompliant: width is written but never read
    
      public Rectangle(int length, int width)
      {
        this.length = length;
        this.width = width;
      }
    
      public int Surface
      {
        get
        {
          return length * width;
        }
      }
    }

Remove this field if it doesn’t need to be read, or fix the code to read it.

    public class Rectangle
    {
      private readonly int length;
      private readonly int width;
    
      public Rectangle(int length, int width)
      {
        this.length = length;
        this.width = width;
      }
    
      public int Surface
      {
        get
        {
          return length * width;
        }
      }
    }

## Resources

### Standards

- CWE - [CWE-563 - Assignment to Variable without Use ('Unused Variable')](https://cwe.mitre.org/data/definitions/563)