Lightweight Directory Access Protocol (LDAP) servers provide two main authentication methods: the *SASL* and *Simple* ones. The
*Simple Authentication* method also breaks down into three different mechanisms:

- *Anonymous* Authentication
- *Unauthenticated* Authentication
- *Name/Password* Authentication

A server that accepts either the *Anonymous* or *Unauthenticated* mechanisms will accept connections from clients not providing
credentials.

## Why is this an issue?

When configured to accept the Anonymous or Unauthenticated authentication mechanism, an LDAP server will accept connections from clients that do
not provide a password or other authentication credentials. Such users will be able to read or modify part or all of the data contained in the hosted
directory.

### What is the potential impact?

An attacker exploiting unauthenticated access to an LDAP server can access the data that is stored in the corresponding directory. The impact
varies depending on the permission obtained on the directory and the type of data it stores.

#### Authentication bypass

If attackers get write access to the directory, they will be able to alter most of the data it stores. This might include sensitive technical data
such as user passwords or asset configurations. Such an attack can typically lead to an authentication bypass on applications and systems that use the
affected directory as an identity provider.

In such a case, all users configured in the directory might see their identity and privileges taken over.

#### Sensitive information leak

If attackers get read-only access to the directory, they will be able to read the data it stores. That data might include security-sensitive pieces
of information.

Typically, attackers might get access to user account lists that they can use in further intrusion steps. For example, they could use such lists to
perform password spraying, or related attacks, on all systems that rely on the affected directory as an identity provider.

If the directory contains some Personally Identifiable Information, an attacker accessing it might represent a violation of regulatory requirements
in some countries. For example, this kind of security event would go against the European GDPR law.

## How to fix it

### Code examples

The following code indicates an anonymous LDAP authentication vulnerability because it binds to a remote server using an Anonymous Simple
authentication mechanism.

#### Noncompliant code example

    DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath);
    myDirectoryEntry.AuthenticationType = AuthenticationTypes.None; // Noncompliant
    
    DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath, "u", "p", AuthenticationTypes.None); // Noncompliant

#### Compliant solution

    DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath); // Compliant; default DirectoryEntry.AuthenticationType property value is "Secure" since .NET Framework 2.0
    
    DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath, "u", "p", AuthenticationTypes.Secure);

## Resources

### Documentation

- [RFC 4513 - Lightweight Directory Access Protocol (LDAP): Authentication
  Methods and Security Mechanisms](https://datatracker.ietf.org/doc/html/rfc4513#section-5) - Bind operations

### Standards

- OWASP - [Top 10 2021 Category A7 - Identification and
  Authentication Failures](https://owasp.org/Top10/A07_2021-Identification_and_Authentication_Failures/)
- OWASP - [Top 10 2017 Category A2 - Broken Authentication](https://owasp.org/www-project-top-ten/2017/A2_2017-Broken_Authentication)
- CWE - [CWE-521 - Weak Password Requirements](https://cwe.mitre.org/data/definitions/521)