## Why is this an issue?

To customize the default behavior for an export in the [Managed Extensibility
Framework](https://learn.microsoft.com/en-us/dotnet/framework/mef/) (MEF), applying the [`PartCreationPolicyAttribute`](https://learn.microsoft.com/en-us/dotnet/api/system.componentmodel.composition.partcreationpolicyattribute)
is necessary. For the [`PartCreationPolicyAttribute`](https://learn.microsoft.com/en-us/dotnet/api/system.componentmodel.composition.partcreationpolicyattribute)
to be meaningful in the context of an export, the class must also be annotated with the [`ExportAttribute`](https://learn.microsoft.com/en-us/dotnet/api/system.componentmodel.composition.exportattribute).

This rule raises an issue when a class is annotated with the `PartCreationPolicyAttribute` but not with the
`ExportAttribute`.

## How to fix it

### Code examples

#### Noncompliant code example

    using System.ComponentModel.Composition;
    
    [PartCreationPolicy(CreationPolicy.Any)] // Noncompliant
    public class FooBar : IFooBar { }

#### Compliant solution

    using System.ComponentModel.Composition;
    
    [Export(typeof(IFooBar))]
    [PartCreationPolicy(CreationPolicy.Any)]
    public class FooBar : IFooBar { }

## Resources

### Documentation

- Microsoft Learn - [Managed Extensibility Framework (MEF)](https://learn.microsoft.com/en-us/dotnet/framework/mef/)
- Microsoft Learn - [Attributed
  programming model overview (MEF)](https://learn.microsoft.com/en-us/dotnet/framework/mef/attributed-programming-model-overview-mef)
- Microsoft Learn - [PartCreationPolicyAttribute
  Class](https://learn.microsoft.com/en-us/dotnet/api/system.componentmodel.composition.partcreationpolicyattribute)
- Microsoft Learn - [ExportAttribute
  Class](https://learn.microsoft.com/en-us/dotnet/api/system.componentmodel.composition.exportattribute)
- Microsoft Learn - [CreationPolicy
  Enum](https://learn.microsoft.com/en-us/dotnet/api/system.componentmodel.composition.creationpolicy)

### Articles & blog posts

- Stefan Henneken - [MEF Part 1 – Fundamentals,
  Imports and Exports](https://stefanhenneken.net/2015/11/08/mef-part-1-fundamentals-imports-and-exports/)
- Stefan Henneken - [MEF Part 2 – Metadata and creation
  policies](https://stefanhenneken.net/2019/01/26/mef-part-2-metadata-and-creation-policies/)
- Stefan Henneken - [MEF Part 3 – Life cycle
  management and monitoring](https://stefanhenneken.net/2019/03/06/mef-part-3-life-cycle-management-and-monitoring/)